/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.state.properties.PassionVineAttachment;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;

public class PassionVineBlock
extends Block
implements BonemealableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    public static final EnumProperty<PassionVineAttachment> ATTACHMENT = EnumProperty.create((String)"attachment", PassionVineAttachment.class);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public PassionVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> null;
        };
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean canFruit;
        int age = (Integer)state.getValue((Property)AGE);
        boolean canFlower = age >= 1;
        boolean bl = canFruit = age < 4 && level.getRawBrightness(pos, 0) >= 5;
        if (canFlower) {
            if (canFruit) {
                if (level.random.nextBoolean()) {
                    this.attemptGrowDown(state, (Level)level, pos, random);
                } else {
                    this.attemptGrowFruit(state, (Level)level, pos, random);
                }
            } else {
                this.attemptGrowDown(state, (Level)level, pos, random);
            }
        } else if (canFruit) {
            this.attemptGrowFruit(state, (Level)level, pos, random);
        }
    }

    public BlockState determineState(BlockState state, LevelReader level, BlockPos pos) {
        boolean vineBelow;
        BlockState below = level.getBlockState(pos.below());
        BlockState above = level.getBlockState(pos.above());
        boolean vineAbove = above.is((Block)this) && above.getValue((Property)FACING) == state.getValue((Property)FACING);
        boolean bl = vineBelow = below.is((Block)this) && below.getValue((Property)FACING) == state.getValue((Property)FACING);
        if (vineAbove) {
            return vineBelow ? (BlockState)state.setValue(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.MIDDLE)) : (BlockState)state.setValue(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.BOTTOM));
        }
        return vineBelow ? (BlockState)state.setValue(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.TOP)) : (BlockState)state.setValue(ATTACHMENT, (Comparable)((Object)PassionVineAttachment.NONE));
    }

    public void attemptGrowFruit(BlockState state, Level level, BlockPos pos, RandomSource random) {
        boolean isHanging;
        int i = (Integer)state.getValue((Property)AGE);
        state = this.determineState(state, (LevelReader)level, pos);
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState hanging = level.getBlockState(pos.relative(direction.getOpposite()));
        if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(7) == 0 ? 1 : 0) != 0) && ((isHanging = hanging.is(AtmosphericBlockTags.PASSION_VINE_GROWABLE_ON)) && i < 4 || !isHanging && i < 1)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void attemptGrowDown(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(7) == 0 ? 1 : 0) != 0) && level.getBlockState(pos.below()).isAir()) {
            level.setBlockAndUpdate(pos.below(), (BlockState)((BlockState)this.determineState(((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState(), (LevelReader)level, pos.below()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age != 4 && stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (age == 1 && stack.is(Tags.Items.TOOLS_SHEAR)) {
            Direction direction = hitResult.getDirection();
            Direction direction1 = direction.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : direction;
            PassionVineBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)direction1, (ItemStack)new ItemStack((ItemLike)Items.WHITE_DYE));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 4) {
            PassionVineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.PASSION_FRUIT.get(), 1 + level.random.nextInt(2) + level.random.nextInt(2) + level.random.nextInt(3)));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, ATTACHMENT, FACING});
    }

    private boolean canAttachTo(BlockGetter level, BlockPos pos, Direction direction) {
        BlockState blockstate = level.getBlockState(pos);
        return !blockstate.isSignalSource() && (blockstate.isFaceSturdy(level, pos, direction) || blockstate.is(BlockTags.LEAVES));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.relative(direction.getOpposite()), direction) || level.getBlockState(pos.above()).is((Block)this) && level.getBlockState(pos.above()).getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(this.determineState(state, (LevelReader)level, pos), facing, facingState, level, pos, facingPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState oppositeState;
        if (!context.replacingClickedOnBlock() && (oppositeState = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()))).getBlock() == this && oppositeState.getValue((Property)FACING) == context.getClickedFace()) {
            return null;
        }
        BlockState state = this.defaultBlockState();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)level, pos)) continue;
            return this.determineState(state, (LevelReader)level, pos);
        }
        return null;
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.getValue((Property)AGE) + 1);
        worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

