/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.PassionVineBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;

public class PassionVineBundleBlock
extends Block {
    protected final RandomSource rand = RandomSource.create();

    public PassionVineBundleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void fallOn(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.causeFallDamage(fallDistance, this.rand.nextFloat(), worldIn.damageSources().fall());
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        block5: {
            Direction direction;
            int counter;
            BlockState nextBlock;
            BlockPos nextPos;
            block4: {
                super.playerDestroy(worldIn, player, pos, state, te, stack);
                if (EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING) || stack.is(Tags.Items.TOOLS_SHEAR)) {
                    worldIn.removeBlock(pos, false);
                    return;
                }
                nextPos = pos.relative(Direction.DOWN);
                nextBlock = worldIn.getBlockState(nextPos);
                counter = 9;
                direction = player.getDirection();
                if (worldIn.getBlockState(pos.relative(direction)).isAir() || !((BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)worldIn, pos)) break block4;
                BlockState vine = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite());
                worldIn.setBlockAndUpdate(pos, vine);
                counter = 8;
                while (counter > 0 && nextBlock.isAir()) {
                    worldIn.setBlockAndUpdate(nextPos, vine);
                    --counter;
                    nextPos = nextPos.relative(Direction.DOWN);
                    nextBlock = worldIn.getBlockState(nextPos);
                }
                if (player.getAbilities().instabuild) break block5;
                PassionVineBundleBlock.popResource((Level)worldIn, (BlockPos)nextPos.relative(Direction.UP), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), counter));
                break block5;
            }
            for (int k1 = 0; k1 < 3; ++k1) {
                direction = direction.getClockWise();
                if (worldIn.getBlockState(pos.relative(direction)).isAir() || !((BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)worldIn, pos)) continue;
                BlockState vine = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite());
                worldIn.setBlockAndUpdate(pos, vine);
                counter = 8;
                while (counter > 0 && nextBlock.isAir()) {
                    worldIn.setBlockAndUpdate(nextPos, vine);
                    --counter;
                    nextPos = nextPos.relative(Direction.DOWN);
                    nextBlock = worldIn.getBlockState(nextPos);
                }
                if (player.getAbilities().instabuild) break;
                PassionVineBundleBlock.popResource((Level)worldIn, (BlockPos)nextPos.relative(Direction.UP), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), counter));
                break;
            }
        }
    }
}

