/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class SnowyBambooBlock
extends BambooStalkBlock {
    public SnowyBambooBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (!fluidstate.isEmpty()) {
            return null;
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().below());
        if (state.is(AtmosphericBlockTags.SNOWY_BAMBOO_PLANTABLE_ON)) {
            if (state.is((Block)AtmosphericBlocks.SNOWY_BAMBOO_SAPLING.get())) {
                return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0));
            }
            if (state.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get())) {
                int i = (Integer)state.getValue((Property)AGE) > 0 ? 1 : 0;
                return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i));
            }
            BlockState aboveState = context.getLevel().getBlockState(context.getClickedPos().above());
            return aboveState.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()) ? (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)((Integer)aboveState.getValue((Property)AGE))) : ((Block)AtmosphericBlocks.SNOWY_BAMBOO_SAPLING.get()).defaultBlockState();
        }
        return null;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.BAMBOO);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(AtmosphericBlockTags.SNOWY_BAMBOO_PLANTABLE_ON);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && offsetState.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()) && (Integer)offsetState.getValue((Property)AGE) > (Integer)state.getValue((Property)AGE)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
        return super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    protected void growBamboo(BlockState state, Level level, BlockPos pos, RandomSource random, int height) {
        BlockState blockstate = level.getBlockState(pos.below());
        BlockPos blockpos = pos.below(2);
        BlockState blockstate1 = level.getBlockState(blockpos);
        BambooLeaves leaves = BambooLeaves.NONE;
        if (height >= 1) {
            if (blockstate.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()) && blockstate.getValue((Property)LEAVES) != BambooLeaves.NONE) {
                if (blockstate.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()) && blockstate.getValue((Property)LEAVES) != BambooLeaves.NONE) {
                    leaves = BambooLeaves.LARGE;
                    if (blockstate1.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get())) {
                        level.setBlock(pos.below(), (BlockState)blockstate.setValue((Property)LEAVES, (Comparable)BambooLeaves.SMALL), 3);
                        level.setBlock(blockpos, (BlockState)blockstate1.setValue((Property)LEAVES, (Comparable)BambooLeaves.NONE), 3);
                    }
                }
            } else {
                leaves = BambooLeaves.SMALL;
            }
        }
        int i = (Integer)state.getValue((Property)AGE) != 1 && !blockstate1.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()) ? 0 : 1;
        int j = !(height >= 11 && random.nextFloat() < 0.25f || height == 15) ? 0 : 1;
        level.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)LEAVES, (Comparable)leaves)).setValue((Property)STAGE, (Comparable)Integer.valueOf(j)), 3);
    }

    protected int getHeightAboveUpToMax(BlockGetter level, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && level.getBlockState(pos.above(i + 1)).is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter level, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && level.getBlockState(pos.below(i + 1)).is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()); ++i) {
        }
        return i;
    }
}

