/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;

public class SnowyBambooSaplingBlock
extends BambooSaplingBlock {
    public SnowyBambooSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(AtmosphericBlockTags.SNOWY_BAMBOO_PLANTABLE_ON);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction == Direction.UP && offsetState.is((Block)AtmosphericBlocks.SNOWY_BAMBOO.get())) {
            level.setBlock(pos, ((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()).defaultBlockState(), 2);
        }
        return state;
    }

    protected void growBamboo(Level level, BlockPos pos) {
        level.setBlock(pos.above(), (BlockState)((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()).defaultBlockState().setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL), 3);
    }
}

