/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class SnowyCactusBlock
extends CactusBlock {
    public SnowyCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos abovePos = pos.above();
        if (level.isEmptyBlock(abovePos)) {
            int i = 1;
            while (level.getBlockState(pos.below(i)).getBlock() instanceof CactusBlock) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)abovePos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        level.setBlockAndUpdate(abovePos, this.defaultBlockState());
                        BlockState newState = (BlockState)Blocks.CACTUS.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0));
                        level.setBlockAndUpdate(pos, newState);
                        level.neighborChanged(newState, abovePos, (Block)this, pos, false);
                    } else {
                        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Blocks.CACTUS);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (direction == Direction.UP && offsetState.is(Blocks.CACTUS)) {
            level.setBlock(pos.above(), BlockUtil.transferAllBlockStates((BlockState)offsetState, (BlockState)this.defaultBlockState()), 2);
            return BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)Blocks.CACTUS.defaultBlockState());
        }
        return super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }
}

