/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.block.YuccaBundleBlock;
import com.teamabnormals.atmospheric.common.block.YuccaPlant;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericDamageTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;

public class YuccaBranchBlock
extends BushBlock
implements BonemealableBlock,
YuccaPlant {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_SNAPPED = Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty SNAPPED = BooleanProperty.create((String)"snapped");

    public YuccaBranchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.is(AtmosphericBlockTags.YUCCA_LOGS);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.mayPlaceOn(worldIn.getBlockState(pos.above()), (BlockGetter)worldIn, pos.above());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)SNAPPED) != false ? SHAPE_SNAPPED : SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNAPPED});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.setBlock(currentPos, (BlockState)stateIn.setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(!(worldIn.getBlockState(currentPos.below()).getBlock() instanceof YuccaBundleBlock))), 2);
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)SNAPPED) != false && worldIn.getBlockState(pos.below()).isAir();
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)SNAPPED);
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)SNAPPED)).booleanValue() && CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(6) == 0 ? 1 : 0) != 0) && worldIn.getBlockState(pos.below()).isAir()) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(false)));
            worldIn.setBlockAndUpdate(pos.below(), ((Block)AtmosphericBlocks.YUCCA_BUNDLE.get()).defaultBlockState());
            CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        } else {
            if (((Boolean)state.getValue((Property)SNAPPED)).booleanValue() && CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0) && worldIn.getBlockState(pos.below()).isAir()) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(false)));
                worldIn.setBlockAndUpdate(pos.below(), ((Block)AtmosphericBlocks.YUCCA_BUNDLE.get()).defaultBlockState());
            }
            CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)SNAPPED)).booleanValue() && stack.is(Tags.Items.TOOLS_SHEAR)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)handIn));
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(true)), 2);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, hit);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        super.entityInside(state, level, pos, entityIn);
        if (entityIn instanceof LivingEntity && !(entityIn instanceof Bee)) {
            this.onYuccaCollision(state, level, pos, entityIn);
        } else if (entityIn instanceof Projectile && !((Boolean)state.getValue((Property)SNAPPED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SNAPPED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return this.getYuccaPathType(entity);
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity, PathType originalType) {
        return this.getYuccaAdjacentPathType(entity);
    }

    @Override
    public float getKnockbackForce() {
        return 0.85f;
    }

    @Override
    public ResourceKey<DamageType> getDamageTypeKey() {
        return AtmosphericDamageTypes.YUCCA_BRANCH;
    }
}

