/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.block.CandleGateauBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class YuccaGateauBlock
extends HorizontalDirectionalBlock {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)9);
    protected static final VoxelShape[] NORTH_SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)4.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)5.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)6.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)7.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)8.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)9.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)12.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0)};
    protected static final VoxelShape[] EAST_SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)7.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)8.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)9.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)10.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)6.0, (double)13.0)};
    protected static final VoxelShape[] SOUTH_SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)11.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)10.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)9.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)8.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)7.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)6.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)6.0, (double)13.0)};
    protected static final VoxelShape[] WEST_SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)11.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)10.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)9.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)8.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)7.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)6.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)5.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)4.0)};

    public YuccaGateauBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int bites = (Integer)state.getValue((Property)BITES);
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> EAST_SHAPES[bites];
            case Direction.SOUTH -> SOUTH_SHAPES[bites];
            case Direction.WEST -> WEST_SHAPES[bites];
            default -> NORTH_SHAPES[bites];
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block block;
        Item item = stack.getItem();
        if (stack.is(ItemTags.CANDLES) && (Integer)state.getValue((Property)BITES) == 0 && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
            CandleBlock candleblock = (CandleBlock)block;
            stack.consume(1, (LivingEntity)player);
            level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(pos, (BlockState)CandleGateauBlock.byCandle(candleblock).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (YuccaGateauBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return YuccaGateauBlock.eat((LevelAccessor)level, pos, state, player);
    }

    public static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(1, 0.0f);
        player.addEffect(new MobEffectInstance(AtmosphericMobEffects.PERSISTENCE, 320, 0, true, false, true));
        player.clearFire();
        int i = (Integer)state.getValue((Property)BITES);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 9) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayerentity = (ServerPlayer)player;
                if (!player.getCommandSenderWorld().isClientSide()) {
                    ((PlayerTrigger)AtmosphericCriteriaTriggers.FINISH_GATEAU.get()).trigger(serverplayerentity);
                }
            }
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES, FACING});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return (10 - (Integer)blockState.getValue((Property)BITES)) * 2;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

