/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface YuccaPlant {
    public float getKnockbackForce();

    public ResourceKey<DamageType> getDamageTypeKey();

    default public void onYuccaCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        VoxelShape collision = state.getShape((BlockGetter)level, pos, CollisionContext.empty()).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        boolean colliding = entity.getBoundingBox().intersects(collision.bounds().inflate(1.0E-7));
        if (colliding && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!(entity.getType().is(AtmosphericEntityTypeTags.YUCCA_IMMUNE) || level.isClientSide || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                double d0 = Math.abs(entity.getX() - entity.xOld);
                double d1 = Math.abs(entity.getZ() - entity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    if (!entity.isCrouching()) {
                        living.knockback((double)this.getKnockbackForce(), (double)(-Mth.sin((float)((float)((double)entity.getYRot() * Math.PI / 180.0)))), (double)Mth.cos((float)((float)((double)entity.getYRot() * Math.PI / 180.0))));
                    }
                    DamageSource source = level.damageSources().source(this.getDamageTypeKey());
                    if (living.getItemBySlot(EquipmentSlot.HEAD).is((Item)AtmosphericItems.BARREL_CACTUS.get())) {
                        entity.hurt(source, 0.01f);
                    } else {
                        entity.hurt(source, 1.0f);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        if (!entity.getCommandSenderWorld().isClientSide() && !serverPlayer.isCreative()) {
                            ((PlayerTrigger)AtmosphericCriteriaTriggers.YUCCA_PRICK.get()).trigger(serverPlayer);
                        }
                    }
                }
            }
        }
    }

    default public PathType getYuccaPathType(@Nullable Mob entity) {
        return entity != null && entity.getType().is(AtmosphericEntityTypeTags.YUCCA_IMMUNE) ? null : PathType.DAMAGE_OTHER;
    }

    default public PathType getYuccaAdjacentPathType(@Nullable Mob entity) {
        return entity != null && entity.getType().is(AtmosphericEntityTypeTags.YUCCA_IMMUNE) ? null : PathType.DANGER_OTHER;
    }
}

