/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.dispenser;

import com.teamabnormals.atmospheric.common.block.PassionVineBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PassionVineBundleDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel worldIn = source.level().getLevel();
            BlockPos pos = source.pos().relative(direction);
            BlockPos nextPos = pos.relative(Direction.DOWN);
            BlockState nextBlock = worldIn.getBlockState(nextPos);
            int counter = 9;
            if (direction != Direction.UP && direction != Direction.DOWN && worldIn.getBlockState(pos).isAir()) {
                BlockState vine = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction);
                worldIn.setBlockAndUpdate(pos, vine);
                counter = 8;
                while (counter > 0 && nextBlock.isAir()) {
                    worldIn.setBlockAndUpdate(nextPos, vine);
                    --counter;
                    nextPos = nextPos.relative(Direction.DOWN);
                    nextBlock = worldIn.getBlockState(nextPos);
                }
            }
            Block.popResource((Level)worldIn, (BlockPos)nextPos.relative(Direction.UP), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), counter));
            stack.shrink(1);
        }
        return stack;
    }
}

