/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.dispenser;

import com.teamabnormals.atmospheric.common.block.PassionVineBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PassionVineDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel worldIn = source.level();
            BlockPos pos = source.pos().relative(direction);
            if (direction != Direction.UP && direction != Direction.DOWN && worldIn.getBlockState(pos).isAir()) {
                BlockState vine = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction);
                worldIn.setBlockAndUpdate(pos, vine);
            } else {
                Position position = DispenserBlock.getDispensePosition((BlockSource)source);
                ItemStack itemstack = stack.split(1);
                PassionVineDispenseBehavior.spawnItem((Level)source.level(), (ItemStack)itemstack, (int)6, (Direction)direction, (Position)position);
            }
            stack.shrink(1);
        }
        return stack;
    }
}

