/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.effect;

import com.teamabnormals.atmospheric.common.entity.projectile.PassionFruitSeed;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SpittingEffect
extends MobEffect {
    public SpittingEffect() {
        super(MobEffectCategory.BENEFICIAL, 15454786);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        RandomSource random = entity.getRandom();
        Level level = entity.level();
        if (!level.isClientSide && entity.getHealth() > 0.0f) {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)AtmosphericSoundEvents.PASSION_FRUIT_SEED_SPIT.get(), SoundSource.NEUTRAL, 0.5f, 0.4f + (random.nextFloat() - random.nextFloat()) * 0.2f);
            PassionFruitSeed seed = new PassionFruitSeed(level, entity, amplifier);
            seed.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, amplifier + 1, 1.0f);
            level.addFreshEntity((Entity)seed);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % (6 / Math.min(amplifier + 1, 6)) == 0;
    }
}

