/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericCamelVariants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record CamelVariant(ResourceLocation assetId, HolderSet<Biome> biomes) {
    public static final Codec<CamelVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(CamelVariant::assetId), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(CamelVariant::biomes)).apply((Applicative)instance, CamelVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CamelVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CamelVariant::assetId, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME), CamelVariant::biomes, CamelVariant::new);
    public static final Codec<Holder<CamelVariant>> CODEC = RegistryFileCodec.create(AtmosphericRegistries.CAMEL_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<CamelVariant>> STREAM_CODEC = ByteBufCodecs.holder(AtmosphericRegistries.CAMEL_VARIANT, DIRECT_STREAM_CODEC);

    public static Holder<CamelVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> biome) {
        Registry registry = registryAccess.registryOrThrow(AtmosphericRegistries.CAMEL_VARIANT);
        return (Holder)registry.holders().filter(holder -> ((CamelVariant)holder.value()).biomes().contains(biome)).findFirst().or(() -> registry.getHolder(AtmosphericCamelVariants.DEFAULT)).or(() -> ((Registry)registry).getAny()).orElseThrow();
    }
}

