/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealAttachToCactusGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealBreedGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealDetachFromCactusGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealEatDragonFruitGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealPanicGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealRandomHopGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealRandomSwimGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealTemptGoal;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import com.teamabnormals.blueprint.common.network.particle.SpawnParticlesPayload;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class Cochineal
extends Animal
implements Saddleable {
    private static final EntityDimensions SUCKLING_DIMENSIONS = EntityDimensions.scalable((float)0.8f, (float)1.25f);
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.defineId(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_LEAPING = SynchedEntityData.defineId(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> CACTUS_POS = SynchedEntityData.defineId(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Direction> CACTUS_SIDE = SynchedEntityData.defineId(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<ItemStack> EATING_STACK = SynchedEntityData.defineId(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private BlockPos lastHabitatBiomePos;
    private int forgetHabitatBiomePosCounter;
    private boolean wasOnGroundOrFluid;
    private boolean jumpingQuickly;
    private boolean superInLove;
    private int jumpDelayTicks;
    private int suckleCooldown;
    private int suckleHealTicks;
    private boolean jumpAnim;
    private float jumpAmount;
    private float jumpAmount0;

    public Cochineal(EntityType<? extends Cochineal> entity, Level level) {
        super(entity, level);
        this.moveControl = new CochinealMoveControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CochinealPanicGoal(this));
        this.goalSelector.addGoal(2, (Goal)new CochinealBreedGoal(this, 1.2));
        this.goalSelector.addGoal(3, (Goal)new CochinealTemptGoal(this, 1.2, Ingredient.of(AtmosphericItemTags.COCHINEAL_FOOD)));
        this.goalSelector.addGoal(4, (Goal)new CochinealEatDragonFruitGoal(this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new CochinealDetachFromCactusGoal(this));
        this.goalSelector.addGoal(6, (Goal)new CochinealAttachToCactusGoal(this));
        this.goalSelector.addGoal(7, (Goal)new CochinealRandomSwimGoal(this, 1.2));
        this.goalSelector.addGoal(8, (Goal)new CochinealRandomHopGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.GRAVITY, 0.04);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AtmosphericItemTags.COCHINEAL_FOOD);
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return (AgeableMob)((EntityType)AtmosphericEntityTypes.COCHINEAL.get()).create((Level)level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_SADDLED, (Object)false);
        builder.define(IS_LEAPING, (Object)false);
        builder.define(CACTUS_POS, Optional.empty());
        builder.define(CACTUS_SIDE, (Object)Direction.SOUTH);
        builder.define(EATING_STACK, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("SuperInLove", this.superInLove);
        tag.putBoolean("Saddle", this.isSaddled());
        if (this.isAttachedToCactus()) {
            tag.put("CactusPos", NbtUtils.writeBlockPos((BlockPos)this.getCactusPos()));
            tag.putString("CactusSide", this.getCactusSide().getName());
        }
        if (this.lastHabitatBiomePos != null) {
            tag.put("LastHabitatBiomePos", NbtUtils.writeBlockPos((BlockPos)this.lastHabitatBiomePos));
            tag.putInt("ForgetHabitatBiomePosCounter", this.forgetHabitatBiomePosCounter);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.superInLove = tag.getBoolean("SuperInLove");
        this.setSaddle(tag.getBoolean("Saddle"));
        if (tag.contains("CactusPos")) {
            this.setCactusPos(NbtUtils.readBlockPos((CompoundTag)tag, (String)"CactusPos").orElse(null));
            this.setCactusSide(Direction.byName((String)tag.getString("CactusSide")));
            this.suckleHealTicks = 120;
        }
        if (tag.contains("LastHabitatBiomePos")) {
            this.lastHabitatBiomePos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"LastHabitatBiomePos").orElse(null);
            this.forgetHabitatBiomePosCounter = tag.getInt("ForgetHabitatBiomePosCounter");
        }
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(IS_SADDLED);
    }

    public void setSaddle(boolean saddle) {
        this.entityData.set(IS_SADDLED, (Object)saddle);
    }

    public boolean isLeaping() {
        return (Boolean)this.entityData.get(IS_LEAPING);
    }

    public void setLeaping(boolean leaping) {
        this.entityData.set(IS_LEAPING, (Object)leaping);
    }

    public void setJumpingQuickly(boolean jumpingQuickly) {
        this.jumpingQuickly = jumpingQuickly;
    }

    public boolean isSuperInLove() {
        return this.superInLove;
    }

    public void setSuperInLove(boolean superInLove) {
        this.superInLove = superInLove;
    }

    public BlockPos getCactusPos() {
        return ((Optional)this.entityData.get(CACTUS_POS)).orElse(null);
    }

    public void setCactusPos(BlockPos pos) {
        this.entityData.set(CACTUS_POS, Optional.ofNullable(pos));
    }

    public Direction getCactusSide() {
        return (Direction)this.entityData.get(CACTUS_SIDE);
    }

    public void setCactusSide(Direction side) {
        this.entityData.set(CACTUS_SIDE, (Object)side);
    }

    public ItemStack getEatingStack() {
        return (ItemStack)this.entityData.get(EATING_STACK);
    }

    public void setEatingStack(ItemStack stack) {
        this.entityData.set(EATING_STACK, (Object)stack);
    }

    public boolean isOnSuckleCooldown() {
        return this.suckleCooldown > 0;
    }

    public BlockPos getLastHabitatBiomePos() {
        double dz;
        double dx;
        if (this.lastHabitatBiomePos != null && (dx = this.getX() - (double)this.lastHabitatBiomePos.getX()) * dx + (dz = this.getZ() - (double)this.lastHabitatBiomePos.getZ()) * dz > 16384.0) {
            this.lastHabitatBiomePos = null;
        }
        return this.lastHabitatBiomePos;
    }

    public boolean isAttachedToCactus() {
        return this.getCactusPos() != null;
    }

    public void attachToCactus(BlockPos cactusPos, Direction cactusSide) {
        this.setCactusPos(cactusPos);
        this.setCactusSide(cactusSide);
        this.setDeltaMovement(Vec3.ZERO);
        this.setPos(this.getCactusAttachPoint(cactusPos, cactusSide));
        this.ejectPassengers();
        this.setDiscardFriction(false);
        this.setLeaping(false);
        this.suckleHealTicks = 120;
        this.suckleCooldown = 200;
        this.playSound((SoundEvent)AtmosphericSoundEvents.COCHINEAL_GRAB.get(), 1.0f, 0.8f / (this.getRandom().nextFloat() * 0.8f + 0.8f));
    }

    public void detachFromCactus() {
        this.setCactusPos(null);
        this.suckleCooldown = 100;
    }

    private Vec3 getCactusAttachPoint(BlockPos cactusPos, Direction cactusSide) {
        VoxelShape shape = this.level().getBlockState(cactusPos).getCollisionShape((BlockGetter)this.level(), cactusPos);
        double x = cactusPos.getX();
        double z = cactusPos.getZ();
        if (cactusSide.getAxis() == Direction.Axis.X) {
            x += cactusSide == Direction.WEST ? shape.min(Direction.Axis.X) : shape.max(Direction.Axis.X);
            z += 0.5;
            x += (double)this.getBbWidth() * 0.5 * (double)cactusSide.getStepX();
        } else {
            x += 0.5;
            z += cactusSide == Direction.NORTH ? shape.min(Direction.Axis.Z) : shape.max(Direction.Axis.Z);
            z += (double)this.getBbWidth() * 0.5 * (double)cactusSide.getStepZ();
        }
        return new Vec3(x, (double)cactusPos.getY() + 0.5 - (double)this.getBbHeight() * 0.5, z);
    }

    public boolean isSuckleable(BlockPos pos) {
        return this.level().getBlockState(pos).is(AtmosphericBlockTags.COCHINEALS_CAN_FEED_ON);
    }

    public Direction getClosestVisibleCactusFace(BlockPos cactusPos) {
        Direction closestdir = null;
        double closestdist = Double.MAX_VALUE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            double distance;
            BlockPos sidepos = cactusPos.relative(direction);
            Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            Vec3 vec31 = new Vec3((double)sidepos.getX() + 0.5, (double)sidepos.getY() + 0.5, (double)sidepos.getZ() + 0.5);
            if (!this.hasSpaceOnCactusSide(cactusPos, direction) || this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS || !((distance = this.distanceToSqr(sidepos.getX(), sidepos.getY(), sidepos.getZ())) < closestdist)) continue;
            closestdir = direction;
            closestdist = distance;
        }
        return closestdir;
    }

    public boolean hasSpaceOnCactusSide(BlockPos cactusPos, Direction cactusSide) {
        double x;
        AABB aabb = new AABB(0.0, 0.5 - (double)this.getBbHeight() * 0.5, 0.0, 1.0, 0.5 + (double)this.getBbHeight() * 0.5, 1.0).deflate(1.0E-6);
        VoxelShape shape = this.level().getBlockState(cactusPos).getCollisionShape((BlockGetter)this.level(), cactusPos);
        double d = cactusSide == Direction.WEST ? shape.min(Direction.Axis.X) - 1.0 : (x = cactusSide == Direction.EAST ? shape.max(Direction.Axis.X) : 0.0);
        double z = cactusSide == Direction.NORTH ? shape.min(Direction.Axis.Z) - 1.0 : (cactusSide == Direction.SOUTH ? shape.max(Direction.Axis.Z) : 0.0);
        aabb = aabb.move((double)cactusPos.getX() + x, (double)cactusPos.getY(), (double)cactusPos.getZ() + z);
        for (VoxelShape voxelshape : this.level().getBlockCollisions((Entity)this, aabb)) {
            if (voxelshape.isEmpty()) continue;
            return false;
        }
        for (Cochineal cochineal : this.level().getEntitiesOfClass(Cochineal.class, aabb)) {
            if (cochineal == this || !cochineal.isAttachedToCactus()) continue;
            return false;
        }
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isFood(stack)) {
            int i = this.getAge();
            if (!this.level().isClientSide && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(player, hand, stack);
                this.setInLove(player);
                if (stack.is(AtmosphericItemTags.COCHINEAL_SUPER_LOVE_FOOD)) {
                    this.setSuperInLove(true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.usePlayerItem(player, hand, stack);
                this.ageUp(Cochineal.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        } else {
            if (this.isSaddled() && !this.isVehicle() && !player.isSecondaryUseActive() && !this.isAttachedToCactus()) {
                if (!this.level().isClientSide) {
                    player.startRiding((Entity)this);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (stack.is(Items.SADDLE)) {
                return stack.interactLivingEntity(player, (LivingEntity)this, hand);
            }
        }
        return InteractionResult.PASS;
    }

    public void equipSaddle(ItemStack stack, @Nullable SoundSource source) {
        this.entityData.set(IS_SADDLED, (Object)true);
        if (source != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.PIG_SADDLE, source, 0.5f, 1.0f);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 1) {
            this.spawnSprintParticle();
            this.jumpAnim = true;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void tick() {
        super.tick();
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if ((this.onGround() || this.isInFluidType()) && !this.wasOnGroundOrFluid) {
            this.setDiscardFriction(false);
            this.setLeaping(false);
            this.jumpDelayTicks = this.jumpingQuickly ? 2 : 10;
        }
        boolean bl = this.wasOnGroundOrFluid = this.onGround() || this.isInFluidType();
        if (this.isAttachedToCactus()) {
            if (this.isSuckleable(this.getCactusPos()) && this.distanceToSqr(this.getCactusAttachPoint(this.getCactusPos(), this.getCactusSide())) < 0.2) {
                this.setDeltaMovement(Vec3.ZERO);
                this.setYRot(this.getCactusSide().getOpposite().toYRot());
                this.yHeadRot = this.getYRot();
                this.yBodyRot = this.getYRot();
            } else if (!this.level().isClientSide) {
                this.detachFromCactus();
            }
        }
    }

    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive() && this.getAge() < 0 && !this.isAttachedToCactus()) {
            this.setAge(this.age - 1);
        }
        super.aiStep();
        if (this.getInLoveTime() == 0) {
            this.setSuperInLove(false);
        }
        this.jumpAmount0 = this.jumpAmount;
        if (this.jumpAnim) {
            if (this.jumpAmount < 1.0f) {
                this.jumpAmount = Math.min(this.jumpAmount + 0.5f, 1.0f);
            } else {
                this.jumpAnim = false;
            }
        } else if (this.jumpAmount > 0.0f) {
            this.jumpAmount = Math.max(this.jumpAmount - 0.1f, 0.0f);
        }
        if (this.isAlive()) {
            if (!this.level().isClientSide) {
                if (this.suckleCooldown > 0) {
                    --this.suckleCooldown;
                }
                if (this.getHealth() < this.getMaxHealth() && this.isAttachedToCactus() && this.suckleHealTicks-- <= 0) {
                    this.heal(1.0f);
                    this.suckleHealTicks = 120;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    double d2 = this.random.nextGaussian() * 0.02;
                    NetworkUtil.spawnParticle((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)ParticleTypes.HEART, List.of(new SpawnParticlesPayload.ParticleInstance(this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2)));
                }
            } else {
                if (this.isLeaping() || this.hurtTime > 0) {
                    boolean cold = ((Biome)this.level().getBiome(this.blockPosition()).value()).coldEnoughToSnow(this.blockPosition());
                    for (int i = 0; i < 3; ++i) {
                        double x = -this.getLookAngle().x * 0.7 + (this.random.nextDouble() - 0.5) * 0.6;
                        double y = 0.6 + (this.random.nextDouble() - 0.5) * 0.6;
                        double z = -this.getLookAngle().z * 0.7 + (this.random.nextDouble() - 0.5) * 0.6;
                        if (this.isBaby()) {
                            x *= 0.4;
                            y *= 0.4;
                            z *= 0.4;
                        }
                        this.level().addParticle(cold ? (ParticleOptions)AtmosphericParticleTypes.COLD_COCHINEAL_TRAIL.get() : (ParticleOptions)AtmosphericParticleTypes.COCHINEAL_TRAIL.get(), this.getX() + x, this.getY() + y, this.getZ() + z, 0.0, 0.0, 0.0);
                    }
                }
                if (this.isAttachedToCactus() && this.isBaby() && this.random.nextInt(160) == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
            }
            if (this.isAttachedToCactus() && this.random.nextInt(200) == 0) {
                this.playSound((SoundEvent)AtmosphericSoundEvents.COCHINEAL_SUCKLE.get(), 0.85f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            }
            if (!this.getEatingStack().isEmpty() && this.tickCount % 12 == 0) {
                this.playSound((SoundEvent)AtmosphericSoundEvents.COCHINEAL_SUCKLE.get(), 1.4f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                if (this.level().isClientSide) {
                    for (int i = 0; i < 6; ++i) {
                        Vec3 vec3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
                        vec3 = vec3.xRot(-this.getXRot() * ((float)Math.PI / 180));
                        vec3 = vec3.yRot(-this.getYRot() * ((float)Math.PI / 180));
                        double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
                        Vec3 vec31 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.8, d0, 0.8 + ((double)this.random.nextFloat() - 0.5) * 0.4);
                        vec31 = vec31.yRot(-this.yBodyRot * ((float)Math.PI / 180));
                        vec31 = vec31.add(this.getX(), this.getY() + 1.0, this.getZ());
                        this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getEatingStack()), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
                    }
                }
            }
        }
    }

    public void knockback(double force, double x, double z) {
        super.knockback(force, x, z);
        this.detachFromCactus();
    }

    protected void leap(double jumpPower) {
        Vec3 vec3 = this.getDeltaMovement();
        double speed = ((CochinealMoveControl)this.moveControl).leapSpeed;
        this.setDeltaMovement(vec3.x, jumpPower + (double)this.getJumpBoostPower(), vec3.z);
        this.moveRelative((float)speed, new Vec3(0.0, 0.0, 1.0));
        this.setLeaping(true);
        this.level().broadcastEntityEvent((Entity)this, (byte)1);
        if (this.level().getBiome(this.blockPosition()).is(AtmosphericBiomeTags.IS_COCHINEAL_HABITAT)) {
            this.lastHabitatBiomePos = this.blockPosition();
            this.forgetHabitatBiomePosCounter = 100;
        } else if (this.lastHabitatBiomePos != null && this.forgetHabitatBiomePosCounter-- <= 0) {
            this.lastHabitatBiomePos = null;
        }
        this.hasImpulse = true;
        this.playSound((SoundEvent)AtmosphericSoundEvents.COCHINEAL_BOUNCE.get(), 2.5f, 0.8f / (this.getRandom().nextFloat() * 0.2f + 0.8f));
        CommonHooks.onLivingJump((LivingEntity)this);
    }

    public boolean canLeap() {
        return this.onGround() && !this.isLeaping() && !((CochinealMoveControl)this.moveControl).wantsToLeap && this.jumpDelayTicks == 0;
    }

    public float getJumpAmount(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.jumpAmount0, (float)this.jumpAmount);
    }

    public int getMaxHeadXRot() {
        return 0;
    }

    public int getMaxHeadYRot() {
        return 5;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.4f : 1.0f;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isAttachedToCactus() ? SUCKLING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(pose);
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)AtmosphericSoundEvents.COCHINEAL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AtmosphericSoundEvents.COCHINEAL_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    protected void ageBoundaryReached() {
        if (!this.isBaby() && this.isAttachedToCactus() && !this.hasSpaceOnCactusSide(this.getCactusPos(), this.getCactusSide())) {
            this.detachFromCactus();
        }
    }

    public boolean isPushable() {
        return !this.isAttachedToCactus() && super.isPushable();
    }

    protected void doPush(Entity entity) {
        if (!this.isAttachedToCactus()) {
            super.doPush(entity);
        }
    }

    protected void pushEntities() {
        if (!this.isAttachedToCactus()) {
            super.pushEntities();
        }
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (CACTUS_POS.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        BlockPos blockpos = this.blockPosition();
        if (this.level().getBiome(blockpos).is(AtmosphericBiomeTags.IS_COCHINEAL_HABITAT)) {
            this.lastHabitatBiomePos = blockpos;
            this.forgetHabitatBiomePosCounter = 100;
        }
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    public MoveControl getMoveControl() {
        return this.moveControl;
    }

    protected PathNavigation createNavigation(Level level) {
        return new CochinealNavigation(this, level);
    }

    public static class CochinealMoveControl
    extends MoveControl {
        private final Cochineal cochineal;
        private double jumpX;
        private double jumpY;
        private double jumpZ;
        private boolean wantsToLeap;
        private int justLeapedTime;
        private double leapSpeed;

        public CochinealMoveControl(Cochineal cochineal) {
            super((Mob)cochineal);
            this.cochineal = cochineal;
        }

        public void tick() {
            if (this.cochineal.isInFluidType()) {
                super.tick();
                this.wantsToLeap = false;
                return;
            }
            if (this.cochineal.isLeaping()) {
                Vec3 vec3 = new Vec3(this.jumpX - this.mob.getX(), 0.0, this.jumpZ - this.mob.getZ()).normalize();
                double d0 = this.cochineal.getDeltaMovement().horizontalDistance();
                if (this.justLeapedTime > 0) {
                    --this.justLeapedTime;
                    if (d0 < this.leapSpeed) {
                        Vec3 vec31 = vec3.scale(Math.min(0.2, this.leapSpeed - d0));
                        this.cochineal.setDeltaMovement(this.cochineal.getDeltaMovement().add(vec31));
                    }
                } else if (d0 < Math.min(0.1, this.leapSpeed)) {
                    Vec3 vec31 = vec3.scale(Math.min(0.04, Math.min(0.1, this.leapSpeed) - d0));
                    this.cochineal.setDeltaMovement(this.cochineal.getDeltaMovement().add(vec31));
                }
                this.cochineal.setDiscardFriction(true);
                this.stopSwimmingNaviation();
            } else if (this.cochineal.onGround()) {
                if (this.wantsToLeap && this.cochineal.jumpDelayTicks == 0) {
                    if (this.canReach(this.jumpX, this.jumpY, this.jumpZ)) {
                        double dx = this.jumpX - this.mob.getX();
                        double dy = this.jumpY - this.mob.getY();
                        double dz = this.jumpZ - this.mob.getZ();
                        double distance = Math.sqrt(dx * dx + dz * dz);
                        this.faceJumpPoint();
                        double jumppower = this.cochineal.jumpingQuickly ? Mth.clamp((double)(0.4 + dy * 0.05), (double)0.4, (double)0.8) : Mth.clamp((double)(0.5 + dy * 0.05), (double)0.4, (double)0.8);
                        this.leapSpeed = this.calculateJumpSpeed(distance, dy, jumppower += (double)this.cochineal.getJumpBoostPower());
                        this.cochineal.leap(jumppower);
                        this.justLeapedTime = 3;
                    }
                    this.wantsToLeap = false;
                }
                this.stopSwimmingNaviation();
            }
        }

        public void leapTo(double x, double y, double z) {
            this.jumpX = x;
            this.jumpY = y;
            this.jumpZ = z;
            this.wantsToLeap = true;
            this.faceJumpPoint();
        }

        private void stopSwimmingNaviation() {
            this.operation = MoveControl.Operation.WAIT;
            this.cochineal.getNavigation().stop();
            this.cochineal.setZza(0.0f);
        }

        public boolean canReach(double x, double y, double z) {
            double dx = x - this.mob.getX();
            double dy = y - this.mob.getY();
            double dz = z - this.mob.getZ();
            return dy <= 8.0 && dy >= -8.0 && dx * dx + dz * dz <= 256.0;
        }

        private void faceJumpPoint() {
            this.cochineal.setYRot((float)(Mth.atan2((double)(this.jumpZ - this.cochineal.getZ()), (double)(this.jumpX - this.cochineal.getX())) * 57.2957763671875) - 90.0f);
            this.cochineal.yBodyRot = this.cochineal.getYRot();
            this.cochineal.yHeadRot = this.cochineal.getYRot();
        }

        private double calculateJumpSpeed(double distance, double height, double jumpPower) {
            double gravity = -this.cochineal.getAttributeValue(Attributes.GRAVITY);
            if (height == 0.0) {
                return -gravity * distance / Math.abs(jumpPower) / 2.0;
            }
            return distance * (jumpPower - Math.sqrt(jumpPower * jumpPower + 2.0 * height * gravity)) / height / 2.0;
        }
    }

    static class CochinealNavigation
    extends GroundPathNavigation {
        private final Cochineal cochineal;

        CochinealNavigation(Cochineal cochineal, Level level) {
            super((Mob)cochineal, level);
            this.cochineal = cochineal;
        }

        public boolean isStableDestination(BlockPos pos) {
            return !this.cochineal.isInFluidType() ? this.level.getBlockState(pos.below()).entityCanStandOn((BlockGetter)this.level, pos.below(), (Entity)this.mob) : super.isStableDestination(pos);
        }
    }
}

