/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;

public class OrangeVaporCloud
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(OrangeVaporCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> IS_BLOOD_ORANGE = SynchedEntityData.defineId(OrangeVaporCloud.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int duration = 600;
    private float radiusPerTick;

    public OrangeVaporCloud(EntityType<? extends OrangeVaporCloud> p_19704_, Level p_19705_) {
        super(p_19704_, p_19705_);
        this.noPhysics = true;
        this.setRadius(1.5f);
    }

    public OrangeVaporCloud(Level level, double x, double y, double z) {
        this((EntityType<? extends OrangeVaporCloud>)((EntityType)AtmosphericEntityTypes.ORANGE_VAPOR_CLOUD.get()), level);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        builder.define(IS_BLOOD_ORANGE, (Object)false);
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Mth.clamp((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    public boolean isBloodOrange() {
        return (Boolean)this.getEntityData().get(IS_BLOOD_ORANGE);
    }

    public void setBloodOrange(boolean bloodOrange) {
        this.getEntityData().set(IS_BLOOD_ORANGE, (Object)bloodOrange);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_19735_) {
        this.duration = p_19735_;
    }

    public void tick() {
        block8: {
            List list1;
            float f;
            block7: {
                boolean fresh;
                super.tick();
                f = this.getRadius();
                if (!this.level().isClientSide) break block7;
                int i = Mth.ceil((float)((float)Math.PI * f * f * 0.05f));
                boolean bl = fresh = this.tickCount < 4;
                if (fresh) {
                    i *= 15;
                }
                for (int j = 0; j < i; ++j) {
                    if (!fresh && this.random.nextInt(8) != 0) continue;
                    float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
                    float f3 = Mth.sqrt((float)this.random.nextFloat()) * f;
                    double d0 = this.getX() + (double)(Mth.cos((float)f2) * f3);
                    double d2 = this.getY() + (double)(this.random.nextFloat() * this.getHeight());
                    double d4 = this.getZ() + (double)(Mth.sin((float)f2) * f3);
                    double d5 = (0.5 - this.random.nextDouble()) * 0.15;
                    double d6 = 0.15;
                    double d7 = (0.5 - this.random.nextDouble()) * 0.15;
                    this.level().addAlwaysVisibleParticle(this.isBloodOrange() ? (ParticleOptions)AtmosphericParticleTypes.BLOOD_ORANGE_VAPOR.get() : (ParticleOptions)AtmosphericParticleTypes.ORANGE_VAPOR.get(), d0, d2, d4, d5, d6, d7);
                }
                break block8;
            }
            if (this.tickCount >= this.duration) {
                this.discard();
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                f += this.radiusPerTick;
                if (this.level().dimensionType().ultraWarm() && !this.isBloodOrange()) {
                    f += this.radiusPerTick * 4.0f;
                }
                if (f < 0.5f) {
                    this.discard();
                    return;
                }
                this.setRadius(f);
            }
            if (this.tickCount % 5 != 0 || (list1 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())).isEmpty()) break block8;
            for (LivingEntity livingentity : list1) {
                if (!(livingentity instanceof Wolf)) continue;
                Wolf wolf = (Wolf)livingentity;
                wolf.isWet = true;
            }
        }
    }

    public void setRadiusPerTick(float p_19739_) {
        this.radiusPerTick = p_19739_;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.tickCount = tag.getInt("Age");
        this.duration = tag.getInt("Duration");
        this.radiusPerTick = tag.getFloat("RadiusPerTick");
        this.setRadius(tag.getFloat("Radius"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("Age", this.tickCount);
        tag.putInt("Duration", this.duration);
        tag.putFloat("RadiusPerTick", this.radiusPerTick);
        tag.putFloat("Radius", this.getRadius());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_19729_);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public float getHeight() {
        return this.getRadius() * 2.0f;
    }

    public EntityDimensions getDimensions(Pose p_19721_) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)this.getHeight());
    }
}

