/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.teamabnormals.atmospheric.common.entity.TetraVariant;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericDataSerializers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericTetraVariants;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class Tetra
extends AbstractSchoolingFish
implements VariantHolder<Holder<TetraVariant>> {
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";
    private static final EntityDataAccessor<Holder<TetraVariant>> VARIANT = SynchedEntityData.defineId(Tetra.class, (EntityDataSerializer)((EntityDataSerializer)AtmosphericDataSerializers.TETRA_VARIANT.get()));

    public Tetra(EntityType<? extends Tetra> p_30015_, Level p_30016_) {
        super(p_30015_, p_30016_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry registry = this.registryAccess().registryOrThrow(AtmosphericRegistries.TETRA_VARIANT);
        builder.define(VARIANT, (Object)((Holder)registry.getHolder(AtmosphericTetraVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.getVariant().unwrapKey().ifPresent(variant -> tag.putString(BUCKET_VARIANT_TAG, variant.location().toString()));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BUCKET_VARIANT_TAG))).map(loc -> ResourceKey.create(AtmosphericRegistries.TETRA_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(AtmosphericRegistries.TETRA_VARIANT).getHolder(key)).ifPresent(this::setVariant);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 2.25));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 2.6, 2.4, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        this.goalSelector.addGoal(4, (Goal)new TetraSwimGoal(this));
        this.goalSelector.addGoal(5, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
    }

    public void setVariant(Holder<TetraVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public Holder<TetraVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> this.getVariant().unwrapKey().ifPresent(variant -> tag.putString(BUCKET_VARIANT_TAG, variant.location().toString())));
    }

    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BUCKET_VARIANT_TAG))).map(loc -> ResourceKey.create(AtmosphericRegistries.TETRA_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(AtmosphericRegistries.TETRA_VARIANT).getHolder(key)).ifPresent(this::setVariant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)AtmosphericItems.TETRA_BUCKET.get());
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_30039_) {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_HURT.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)AtmosphericSoundEvents.TETRA_FLOP.get();
    }

    public int getMaxSchoolSize() {
        return 12;
    }

    public int getMaxSpawnClusterSize() {
        return 12;
    }

    public int getMinSchoolSize() {
        return 6;
    }

    public void tick() {
        super.tick();
        if (this.hasFollowers() && this.isFollower() && !Tetra.tryMergeSchools(this, this.leader)) {
            this.stopFollowing();
        }
        if (!this.isSchoolFull() && this.random.nextInt(50) == 0) {
            List list = this.level().getEntitiesOfClass(((Object)((Object)this)).getClass(), this.getBoundingBox().inflate(8.0, 8.0, 8.0), tetra -> tetra != this && (tetra.canBeFollowed() && tetra != this.leader || !this.isFollower() && !this.hasFollowers() && tetra.schoolSize < tetra.getMaxSchoolSize() && !tetra.isFollower()));
            for (Tetra tetra2 : list) {
                if ((this.hasFollowers() || this.isFollower()) && Tetra.tryMergeSchools((AbstractSchoolingFish)(this.isFollower() ? this.leader : this), tetra2)) break;
                if (this.isFollower() || this.hasFollowers()) continue;
                this.startFollowing(tetra2);
                break;
            }
        }
    }

    public boolean isSchoolFull() {
        return this.hasFollowers() ? this.schoolSize <= this.getMinSchoolSize() : this.isFollower() && this.leader.schoolSize <= this.getMinSchoolSize();
    }

    public static boolean tryMergeSchools(AbstractSchoolingFish from, AbstractSchoolingFish to) {
        if (from.schoolSize + to.schoolSize <= to.getMaxSchoolSize()) {
            List fromFollowers = from.level().getEntitiesOfClass(Tetra.class, from.getBoundingBox().inflate(8.0, 8.0, 8.0), t -> t.isFollower() && t.leader == from);
            fromFollowers.forEach(follower -> {
                follower.stopFollowing();
                follower.startFollowing(to);
            });
            from.startFollowing(to);
            return true;
        }
        return false;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        Holder<TetraVariant> tetraVariant;
        data = super.finalizeSpawn(level, difficulty, spawnType, data);
        RandomSource random = level.getRandom();
        if (data instanceof TetraGroupData) {
            TetraGroupData tetraData = (TetraGroupData)((Object)data);
            tetraVariant = tetraData.variant;
        } else {
            tetraVariant = TetraVariant.getSpawnVariant(level.registryAccess(), random);
            data = new TetraGroupData(this, tetraVariant);
        }
        this.setVariant(tetraVariant);
        return data;
    }

    public static boolean checkTetraSpawnRules(EntityType<Tetra> tetra, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        return level.getFluidState(pos.below()).is(FluidTags.WATER) && level.getBlockState(pos.above()).is(Blocks.WATER) && WaterAnimal.checkSurfaceWaterAnimalSpawnRules(tetra, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)random);
    }

    static class TetraSwimGoal
    extends RandomStrollGoal {
        private final Tetra fish;

        public TetraSwimGoal(Tetra tetra) {
            super((PathfinderMob)tetra, 1.0, 40, false);
            this.fish = tetra;
        }

        public boolean canUse() {
            return this.fish.canRandomSwim() && super.canUse();
        }

        @Nullable
        protected Vec3 getPosition() {
            return TetraSwimGoal.getRandomSwimmablePos(this.mob, 10, 7);
        }

        @Nullable
        public static Vec3 getRandomSwimmablePos(PathfinderMob mob, int xz, int y) {
            Vec3 vec3 = TetraSwimGoal.getPos(mob, xz, y);
            int i = 0;
            while (vec3 != null && !mob.level().getBlockState(BlockPos.containing((Position)vec3)).isPathfindable(PathComputationType.WATER) && i++ < 10) {
                vec3 = TetraSwimGoal.getPos(mob, xz, y);
            }
            return vec3;
        }

        @Nullable
        public static Vec3 getPos(PathfinderMob tetra, int xz, int y) {
            Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)tetra, (int)xz, (int)y);
            if (vec3 != null) {
                boolean wrongBiome;
                Level level = tetra.level();
                RandomSource random = tetra.getRandom();
                BlockPos pos = tetra.getOnPos();
                BlockPos newPos = BlockPos.containing((Position)vec3);
                Holder oldBiome = level.getBiome(pos);
                Holder newBiome = level.getBiome(newPos);
                int newLight = level.getRawBrightness(newPos, 0);
                boolean tooBright = newLight > 5 && random.nextFloat() < (float)newLight / 16.0f;
                boolean bl = wrongBiome = oldBiome.is(AtmosphericBiomeTags.IS_RAINFOREST) && !newBiome.is(AtmosphericBiomeTags.IS_RAINFOREST) && random.nextFloat() < 0.95f;
                if (tooBright || wrongBiome) {
                    return TetraSwimGoal.getPos(tetra, xz, y);
                }
            }
            return vec3;
        }
    }

    static class TetraGroupData
    extends AbstractSchoolingFish.SchoolSpawnGroupData {
        final Holder<TetraVariant> variant;

        TetraGroupData(Tetra leader, Holder<TetraVariant> variant) {
            super((AbstractSchoolingFish)leader);
            this.variant = variant;
        }
    }

    static class TetraFollowFlockLeader
    extends FollowFlockLeaderGoal {
        public TetraFollowFlockLeader(AbstractSchoolingFish fish) {
            super(fish);
        }
    }
}

