/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.google.common.collect.Lists;
import com.teamabnormals.atmospheric.common.entity.Cochineal;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;

public class CochinealAttachToCactusGoal
extends Goal {
    private final Cochineal cochineal;
    private BlockPos cactusPos;
    private Direction cactusSide;
    private int nextStartTicks;
    private int hops;

    public CochinealAttachToCactusGoal(Cochineal cochineal) {
        this.cochineal = cochineal;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.nextStartTicks > 0) {
            --this.nextStartTicks;
            return false;
        }
        this.nextStartTicks = this.adjustedTickDelay(20);
        if (this.cochineal.isInFluidType() || this.cochineal.isAttachedToCactus()) {
            return false;
        }
        if (this.cochineal.isOnSuckleCooldown() || this.cochineal.getRandom().nextInt(this.adjustedTickDelay(this.cochineal.isBaby() || this.cochineal.getHealth() / this.cochineal.getMaxHealth() <= 0.5f ? 5 : 600)) != 0) {
            return false;
        }
        BlockPos blockpos = this.findCactus();
        if (blockpos != null) {
            this.cactusPos = blockpos;
            this.cactusSide = this.cochineal.getClosestVisibleCactusFace(this.cactusPos);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.cochineal.isInFluidType() && !this.cochineal.isAttachedToCactus() && this.cochineal.isSuckleable(this.cactusPos) && this.cochineal.hasSpaceOnCactusSide(this.cactusPos, this.cactusSide) && this.hops > 0;
    }

    public void start() {
        this.hops = 3;
    }

    public void tick() {
        double x = (double)this.cactusPos.getX() + 0.5;
        double y = this.cactusPos.getY();
        double z = (double)this.cactusPos.getZ() + 0.5;
        if (this.cochineal.distanceToSqr(x + (double)this.cactusSide.getStepX(), y, z + (double)this.cactusSide.getStepZ()) < 1.0) {
            this.cochineal.attachToCactus(this.cactusPos, this.cactusSide);
        } else if (this.cochineal.canLeap()) {
            Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.getMoveControl();
            if (control.canReach(x += (double)this.cactusSide.getStepX() * 1.2, y, z += (double)this.cactusSide.getStepZ() * 1.2)) {
                control.leapTo(x, y, z);
            }
            --this.hops;
        }
    }

    private BlockPos findCactus() {
        BlockPos blockpos = this.cochineal.blockPosition();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int r = 0; r < 12; ++r) {
            int x = 0;
            while (x <= r) {
                int z;
                int n = z = x < r && x > -r ? r : 0;
                while (z <= r) {
                    int y = 0;
                    while (y <= 2) {
                        mutable.setWithOffset((Vec3i)blockpos, x, y, z);
                        if (this.cochineal.isSuckleable((BlockPos)mutable)) {
                            ArrayList list = Lists.newArrayList();
                            for (int i = -3; i <= 3; ++i) {
                                BlockPos blockpos1 = mutable.relative(Direction.Axis.Y, i);
                                if (!this.cochineal.isSuckleable(blockpos1) || this.cochineal.getClosestVisibleCactusFace(blockpos1) == null) continue;
                                list.add(blockpos1);
                            }
                            if (!list.isEmpty()) {
                                return (BlockPos)list.get(this.cochineal.getRandom().nextInt(list.size()));
                            }
                        }
                        y = y > 0 ? -y : 1 - y;
                    }
                    z = z > 0 ? -z : 1 - z;
                }
                x = x > 0 ? -x : 1 - x;
            }
        }
        return null;
    }
}

