/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;

public class CochinealBreedGoal
extends BreedGoal {
    private final Cochineal cochineal;

    public CochinealBreedGoal(Cochineal cochineal, double speed) {
        super((Animal)cochineal, speed);
        this.cochineal = cochineal;
    }

    public void start() {
        this.cochineal.detachFromCactus();
    }

    public void tick() {
        super.tick();
        if (!this.cochineal.isInFluidType()) {
            this.cochineal.getNavigation().stop();
            if (this.cochineal.canLeap()) {
                Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.getMoveControl();
                Vec3 vec3 = this.partner.position();
                if (this.cochineal.distanceToSqr(vec3) < 36.0 && control.canReach(vec3.x, vec3.y, vec3.z)) {
                    control.leapTo(vec3.x, vec3.y, vec3.z);
                } else {
                    Vec3 vec31 = DefaultRandomPos.getPosTowards((PathfinderMob)this.cochineal, (int)12, (int)3, (Vec3)vec3, (double)0.5235987755982988);
                    if (vec31 != null) {
                        vec31.add(0.5, 0.0, 0.5);
                        if (control.canReach(vec31.x, vec31.y, vec31.z)) {
                            control.leapTo(vec31.x, vec31.y, vec31.z);
                        }
                    }
                }
            }
        }
    }

    protected void breed() {
        this.spawnBabies((Cochineal)this.animal, this.partner);
        this.spawnBabies((Cochineal)this.partner, this.animal);
    }

    public void spawnBabies(Cochineal cochineal, Animal partner) {
        RandomSource random = this.cochineal.getRandom();
        int count = 1 + random.nextInt(2) + (cochineal.isSuperInLove() ? 2 : 0);
        for (int i = 0; i < count; ++i) {
            cochineal.spawnChildFromBreeding((ServerLevel)this.level, partner);
        }
        cochineal.kill();
    }
}

