/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class CochinealEatDragonFruitGoal
extends Goal {
    private final Cochineal cochineal;
    private final double moveSpeed;
    private ItemEntity itemEntity;
    private int eatTime;
    private int delayCounter;

    public CochinealEatDragonFruitGoal(Cochineal cochineal, double speed) {
        this.cochineal = cochineal;
        this.moveSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.cochineal.getAge() != 0 || !this.cochineal.canFallInLove() || this.cochineal.getRandom().nextInt(this.adjustedTickDelay(20)) != 0) {
            return false;
        }
        List list = this.cochineal.level().getEntitiesOfClass(ItemEntity.class, this.cochineal.getBoundingBox().inflate(12.0, 4.0, 12.0), itemEntity -> this.cochineal.isFood(itemEntity.getItem()));
        ItemEntity itementity = null;
        double d0 = Double.MAX_VALUE;
        for (ItemEntity itementity1 : list) {
            double d1 = this.cochineal.distanceToSqr((Entity)itementity1);
            if (!(d1 < d0)) continue;
            d0 = d1;
            itementity = itementity1;
        }
        if (itementity != null) {
            this.itemEntity = itementity;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.cochineal.getAge() == 0 && this.cochineal.canFallInLove() && this.itemEntity != null && this.itemEntity.isAlive() && this.cochineal.distanceToSqr((Entity)this.itemEntity) <= 256.0;
    }

    public void start() {
        this.eatTime = this.adjustedTickDelay(80);
        this.delayCounter = 0;
    }

    public void stop() {
        this.cochineal.setEatingStack(ItemStack.EMPTY);
    }

    public void tick() {
        if (this.cochineal.getBoundingBox().inflate(0.5).intersects(this.itemEntity.getBoundingBox())) {
            if (this.cochineal.onGround() || this.cochineal.isInFluidType()) {
                this.cochineal.setEatingStack(this.itemEntity.getItem());
                this.cochineal.getLookControl().setLookAt((Entity)this.itemEntity, 10.0f, (float)this.cochineal.getMaxHeadXRot());
                if (this.eatTime-- <= 0) {
                    Player player;
                    Entity entity = this.itemEntity.getOwner();
                    this.cochineal.setInLove(entity instanceof Player ? (player = (Player)entity) : null);
                    this.cochineal.gameEvent((Holder)GameEvent.EAT);
                    if (this.itemEntity.getItem().is(AtmosphericItemTags.COCHINEAL_SUPER_LOVE_FOOD)) {
                        this.cochineal.setSuperInLove(true);
                    }
                    ItemStack itemstack = this.itemEntity.getItem().copy();
                    itemstack.shrink(1);
                    if (itemstack.isEmpty()) {
                        this.itemEntity.discard();
                    } else {
                        this.itemEntity.setItem(itemstack);
                    }
                }
            }
        } else {
            this.cochineal.setEatingStack(ItemStack.EMPTY);
            if (this.cochineal.isInFluidType()) {
                if (--this.delayCounter <= 0) {
                    this.delayCounter = this.adjustedTickDelay(20);
                    Path path = this.cochineal.getNavigation().createPath((Entity)this.itemEntity, 0);
                    if (path != null) {
                        this.cochineal.getNavigation().moveTo(path, this.moveSpeed);
                    }
                }
            } else if (this.cochineal.canLeap()) {
                Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.getMoveControl();
                Vec3 vec3 = this.itemEntity.position();
                if (this.cochineal.distanceToSqr(vec3) < 64.0 && control.canReach(vec3.x, vec3.y, vec3.z)) {
                    control.leapTo(vec3.x, vec3.y, vec3.z);
                } else {
                    Vec3 vec31 = DefaultRandomPos.getPosTowards((PathfinderMob)this.cochineal, (int)12, (int)3, (Vec3)vec3, (double)0.5235987755982988);
                    if (vec31 != null) {
                        vec31.add(0.5, 0.0, 0.5);
                        if (control.canReach(vec31.x, vec31.y, vec31.z)) {
                            control.leapTo(vec31.x, vec31.y, vec31.z);
                        }
                    }
                }
            }
        }
    }
}

