/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class CochinealPanicGoal
extends Goal {
    private final Cochineal cochineal;
    private int idleTime;
    private int fleeTime;
    private float direction;

    public CochinealPanicGoal(Cochineal cochineal) {
        this.cochineal = cochineal;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return !this.cochineal.isInFluidType() && this.shouldPanic();
    }

    public boolean canContinueToUse() {
        return !this.cochineal.isInFluidType() && --this.fleeTime > 0;
    }

    public void start() {
        this.idleTime = 0;
        this.fleeTime = this.adjustedTickDelay(240);
        this.direction = this.cochineal.getRandom().nextFloat() * ((float)Math.PI * 2);
        this.cochineal.setJumpingQuickly(true);
        this.cochineal.detachFromCactus();
    }

    public void stop() {
        this.cochineal.setJumpingQuickly(false);
    }

    public void tick() {
        if (this.cochineal.canLeap()) {
            Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.getMoveControl();
            Vec3 vec3 = this.cochineal.position().add(new Vec3(Math.sin(this.direction) * 32.0, 0.0, Math.cos(this.direction) * 32.0));
            for (int i = 0; i < 3; ++i) {
                Vec3 vec31 = DefaultRandomPos.getPosTowards((PathfinderMob)this.cochineal, (int)14, (int)7, (Vec3)vec3, (double)1.5707963267948966);
                if (vec31 == null) continue;
                vec31.add(0.5, 0.0, 0.5);
                if (!control.canReach(vec31.x, vec31.y, vec31.z)) continue;
                control.leapTo(vec31.x, vec31.y, vec31.z);
                this.idleTime = 0;
                return;
            }
            if (++this.idleTime > this.adjustedTickDelay(40)) {
                this.direction = this.cochineal.getRandom().nextFloat() * ((float)Math.PI * 2);
                this.idleTime = 0;
            }
        }
    }

    private boolean shouldPanic() {
        return this.cochineal.getLastHurtByMob() != null || this.cochineal.isFreezing() || this.cochineal.isOnFire();
    }
}

