/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class CochinealRandomHopGoal
extends Goal {
    private final Cochineal cochineal;
    private int hops;
    private int stuckTime;
    private float direction;

    public CochinealRandomHopGoal(Cochineal cochineal) {
        this.cochineal = cochineal;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return !this.cochineal.isInFluidType() && !this.cochineal.isAttachedToCactus() && this.cochineal.getNoActionTime() < 100 && this.cochineal.getRandom().nextInt(this.adjustedTickDelay(this.cochineal.isBaby() ? 120 : 40)) == 0;
    }

    public boolean canContinueToUse() {
        return !this.cochineal.isInFluidType() && this.hops > 0;
    }

    public void start() {
        this.hops = this.cochineal.getRandom().nextInt(7) + 2;
        this.stuckTime = 0;
        BlockPos blockpos = this.cochineal.getLastHabitatBiomePos();
        this.direction = blockpos != null && !this.cochineal.level().getBiome(this.cochineal.blockPosition()).is(AtmosphericBiomeTags.IS_COCHINEAL_HABITAT) ? (float)Mth.atan2((double)((double)blockpos.getZ() - this.cochineal.getZ()), (double)((double)blockpos.getX() - this.cochineal.getX())) - 1.5707964f : this.cochineal.getYRot();
    }

    public void tick() {
        if (this.cochineal.canLeap()) {
            Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.getMoveControl();
            Vec3 vec3 = this.cochineal.position().add(new Vec3(-Math.sin(this.direction) * 32.0, 0.0, Math.cos(this.direction) * 32.0));
            Vec3 vec31 = DefaultRandomPos.getPosTowards((PathfinderMob)this.cochineal, (int)12, (int)7, (Vec3)vec3, (double)0.7853981633974483);
            if (vec31 != null) {
                vec31.add(0.5, 0.0, 0.5);
                if (control.canReach(vec31.x, vec31.y, vec31.z)) {
                    control.leapTo(vec31.x, vec31.y, vec31.z);
                    --this.hops;
                    this.stuckTime = 0;
                    return;
                }
            }
            if (++this.stuckTime > this.adjustedTickDelay(80)) {
                this.direction = this.cochineal.getRandom().nextFloat() * ((float)Math.PI * 2);
                this.stuckTime = 0;
            }
        }
    }
}

