/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;

public class CochinealTemptGoal
extends TemptGoal {
    private final Cochineal cochineal;
    private int detachTimer;

    public CochinealTemptGoal(Cochineal cochineal, double speed, Ingredient ingredient) {
        super((PathfinderMob)cochineal, speed, (Predicate)ingredient, false);
        this.cochineal = cochineal;
        this.resetDetachTimer();
    }

    public boolean canUse() {
        if (!super.canUse()) {
            this.resetDetachTimer();
            return false;
        }
        if (this.cochineal.isBaby()) {
            return !this.cochineal.isAttachedToCactus();
        }
        if (this.cochineal.isAttachedToCactus() && this.detachTimer > 0) {
            --this.detachTimer;
            return false;
        }
        return true;
    }

    public void start() {
        super.start();
        this.cochineal.detachFromCactus();
        this.resetDetachTimer();
    }

    public void tick() {
        if (this.cochineal.isInFluidType()) {
            super.tick();
        } else if (this.cochineal.canLeap()) {
            this.mob.getLookControl().setLookAt((Entity)this.player, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
            double d0 = this.mob.distanceToSqr((Entity)this.player);
            if (d0 >= 9.0) {
                int i = d0 < 25.0 ? 3 : (d0 < 64.0 ? 7 : 12);
                int j = d0 < 25.0 ? 1 : 3;
                Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.getMoveControl();
                Vec3 vec3 = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)i, (int)j, (Vec3)this.player.position(), (double)0.5235987755982988);
                if (vec3 != null) {
                    vec3.add(0.5, 0.0, 0.5);
                    if (control.canReach(vec3.x, vec3.y, vec3.z)) {
                        control.leapTo(vec3.x, vec3.y, vec3.z);
                    }
                }
            }
        }
    }

    private void resetDetachTimer() {
        this.detachTimer = this.cochineal.getRandom().nextInt(this.adjustedTickDelay(20));
    }
}

