/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.projectile;

import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DragonFruit
extends Entity {
    private static final EntityDataAccessor<Boolean> IS_FLOWERING = SynchedEntityData.defineId(DragonFruit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ENDER = SynchedEntityData.defineId(DragonFruit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Direction rollingDirection = Direction.NORTH;
    public int rollingTicks = 200;

    public DragonFruit(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    public ItemStack getPickResult() {
        return this.getItem();
    }

    public ItemStack getItem() {
        return new ItemStack(this.isEnder() ? (ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get() : (ItemLike)AtmosphericItems.DRAGON_FRUIT.get());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IS_ENDER, (Object)false);
        builder.define(IS_FLOWERING, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        tag.putInt("RollingTicks", this.rollingTicks);
        tag.putInt("RollingDirection", this.getRollingDirection().get3DDataValue());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.rollingTicks = tag.getInt("RollingTicks");
        this.rollingDirection = Direction.from3DDataValue((int)tag.getInt("RollingDirection"));
    }

    public void tick() {
        super.tick();
        if (this.isInFluidType()) {
            this.showBreakingParticles();
            this.breakDragonFruit();
            this.kill();
        }
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            float f1 = 0.98f;
            if (this.onGround()) {
                f1 = this.level().getBlockState(BlockPos.containing((double)this.getX(), (double)(this.getY() - 1.0), (double)this.getZ())).getFriction((LevelReader)this.level(), BlockPos.containing((double)this.getX(), (double)(this.getY() - 1.0), (double)this.getZ()), (Entity)this) * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f1, 0.98, (double)f1));
            if (this.onGround()) {
                Vec3 vec31 = this.getDeltaMovement();
                if (vec31.y < 0.0) {
                    this.setDeltaMovement(vec31.multiply(1.0, -0.5, 1.0));
                }
            }
        }
        if (this.rollingTicks > 0) {
            --this.rollingTicks;
        } else {
            this.showBreakingParticles();
            this.breakDragonFruit();
            this.kill();
        }
        if (this.horizontalCollision) {
            this.showBreakingParticles();
            this.breakDragonFruit();
            this.kill();
        }
        if (this.getRollingDirection() != null && (this.tickCount + this.getId()) % 4 == 0) {
            Vec3i direction = this.getRollingDirection().getNormal();
            double speed = (double)this.rollingTicks / 1000.0;
            speed = Math.max(speed, 0.1);
            if (!this.onGround()) {
                speed *= 0.1;
            }
            this.push((double)direction.getX() * speed, 0.0, (double)direction.getZ() * speed);
        }
    }

    public void setFlowering(boolean flowering) {
        this.entityData.set(IS_FLOWERING, (Object)flowering);
    }

    public boolean isFlowering() {
        return (Boolean)this.entityData.get(IS_FLOWERING);
    }

    public boolean attemptPlaceRoots() {
        if (this.isFlowering() && !this.level().isClientSide()) {
            BlockState rootsState = (BlockState)((BlockState)((BlockState)((Block)AtmosphericBlocks.DRAGON_ROOTS.get()).defaultBlockState().setValue(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS))).setValue(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.NONE))).setValue((Property)DragonRootsBlock.FACING, (Comparable)this.getRollingDirection().getOpposite());
            BlockPos pos = this.blockPosition();
            BlockState state = this.level().getBlockState(pos);
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    rootsState = (BlockState)rootsState.cycle((Property)DragonRootsBlock.FACING);
                }
                if (this.level().isEmptyBlock(pos) && rootsState.canSurvive((LevelReader)this.level(), pos)) {
                    this.level().setBlockAndUpdate(pos, rootsState);
                    return true;
                }
                if (!state.is((Block)AtmosphericBlocks.DRAGON_ROOTS.get()) || DragonRootsBlock.isDouble(state)) continue;
                if (state.getValue(DragonRootsBlock.TOP_STAGE) == DragonRootsStage.NONE) {
                    state = (BlockState)state.setValue(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
                }
                if (state.getValue(DragonRootsBlock.BOTTOM_STAGE) == DragonRootsStage.NONE) {
                    state = (BlockState)state.setValue(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
                }
                this.level().setBlockAndUpdate(pos, state);
                return true;
            }
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.DRAGON_ROOTS.get()));
        }
        return false;
    }

    public void setEnder(boolean ender) {
        this.entityData.set(IS_ENDER, (Object)ender);
    }

    public boolean isEnder() {
        return (Boolean)this.entityData.get(IS_ENDER);
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    public Direction getRollingDirection() {
        Direction dir = this.rollingDirection;
        if (dir == null || dir.getAxis().isVertical()) {
            return Direction.NORTH;
        }
        return this.rollingDirection;
    }

    public void setRollingDirection(Direction direction) {
        this.rollingDirection = direction;
    }

    public boolean hurt(DamageSource source, float damage) {
        if (!this.level().isClientSide && !this.isRemoved()) {
            if (source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
                this.kill();
                return false;
            }
            if (!this.isInvulnerableTo(source)) {
                if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.breakDragonFruit();
                    this.kill();
                    return false;
                }
                boolean flag = source.getDirectEntity() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)source.getDirectEntity()).getPierceLevel() > 0;
                boolean flag2 = "player".equals(source.getMsgId());
                if (!flag2 && !flag) {
                    return false;
                }
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.getAbilities().mayBuild) {
                        return false;
                    }
                }
                if (source.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.kill();
                    return flag1;
                }
                this.breakDragonFruit();
                this.showBreakingParticles();
                this.kill();
                return true;
            }
            return false;
        }
        return false;
    }

    private void breakDragonFruit() {
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)this.getItem());
        this.attemptPlaceRoots();
        this.playBrokenSound();
    }

    private void showBreakingParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SWEET_BERRY_BUSH_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }
}

