/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.projectile;

import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericDamageTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class PassionFruitSeed
extends ThrowableProjectile {
    private int amplifier = 0;

    public PassionFruitSeed(EntityType<? extends PassionFruitSeed> type, Level level) {
        super(type, level);
    }

    public PassionFruitSeed(Level level, LivingEntity shooter, int amplifier) {
        super((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get(), shooter.getX(), shooter.getEyeY() - (double)0.3f, shooter.getZ(), level);
        this.amplifier = amplifier;
        this.setOwner((Entity)shooter);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            result.getEntity().hurt(AtmosphericDamageTypes.passionFruitSeed(this.level(), (Entity)this, (Entity)living), 0.5f + (float)this.amplifier);
            if (!this.level().isClientSide()) {
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }
}

