/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.projectile;

import com.teamabnormals.atmospheric.common.block.PassionVineBlock;
import com.teamabnormals.atmospheric.common.block.PassionVineBundleBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PassionVineCoil
extends ThrowableItemProjectile {
    public PassionVineCoil(Level worldIn, LivingEntity throwerIn) {
        super(EntityType.SNOWBALL, throwerIn, worldIn);
    }

    protected Item getDefaultItem() {
        return Items.SNOWBALL;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ParticleOptions makeParticle() {
        ItemStack stack = this.getItem();
        return stack.isEmpty() ? ParticleTypes.ITEM_SNOWBALL : new ItemParticleOption(ParticleTypes.ITEM, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(iparticledata, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onHitBlock(BlockHitResult result) {
        BlockPos pos;
        block10: {
            Level worldIn = this.getCommandSenderWorld();
            Direction direction = result.getDirection().getAxis().isHorizontal() ? result.getDirection().getOpposite() : this.getOwner().getDirection();
            pos = this.blockPosition();
            BlockPos landedPos = pos.relative(direction);
            if (!worldIn.getBlockState(pos).is((Block)AtmosphericBlocks.PASSION_VINE.get()) && worldIn.getBlockState(landedPos).is((Block)AtmosphericBlocks.PASSION_VINE.get())) {
                pos = landedPos;
            }
            BlockPos nextPos = pos.relative(Direction.DOWN);
            BlockState nextBlock = worldIn.getBlockState(nextPos);
            if (!this.level().getBlockState(pos).isAir()) {
                if (!this.level().getBlockState(pos).is((Block)AtmosphericBlocks.PASSION_VINE.get())) {
                    this.removeVine(nextPos, true);
                    return;
                }
                while (nextBlock.is((Block)AtmosphericBlocks.PASSION_VINE.get())) {
                    nextPos = nextPos.below();
                    nextBlock = worldIn.getBlockState(nextPos);
                }
                if (!nextBlock.isAir()) {
                    this.removeVine(nextPos, true);
                    return;
                }
                pos = nextPos;
                nextPos = pos.below();
                nextBlock = worldIn.getBlockState(nextPos);
            }
            if (((BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)worldIn, pos)) {
                int counter;
                BlockState vine = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite());
                worldIn.setBlockAndUpdate(pos, vine);
                for (counter = 7; counter > 0 && nextBlock.isAir(); --counter, nextPos = nextPos.below()) {
                    worldIn.setBlockAndUpdate(nextPos, vine);
                    nextBlock = worldIn.getBlockState(nextPos);
                }
                PassionVineBundleBlock.popResource((Level)worldIn, (BlockPos)nextPos.relative(Direction.UP), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), counter));
            } else {
                int k1 = 0;
                do {
                    int counter;
                    direction = direction.getClockWise();
                    ++k1;
                    if (!((BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)worldIn, pos)) continue;
                    BlockState vine = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction.getOpposite());
                    worldIn.setBlockAndUpdate(pos, vine);
                    for (counter = 7; counter > 0 && nextBlock.isAir(); --counter, nextPos = nextPos.below()) {
                        worldIn.setBlockAndUpdate(nextPos, vine);
                        nextBlock = worldIn.getBlockState(nextPos);
                    }
                    PassionVineBundleBlock.popResource((Level)worldIn, (BlockPos)nextPos.above(), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), counter));
                    break block10;
                } while (k1 < 3);
                worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                PassionVineBundleBlock.popResource((Level)worldIn, (BlockPos)nextPos.above(), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), 8));
            }
        }
        this.removeVine(pos, false);
    }

    private void removeVine(BlockPos nextPos, boolean doDrops) {
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
        if (doDrops) {
            PassionVineBundleBlock.popResource((Level)this.level(), (BlockPos)nextPos.relative(Direction.UP), (ItemStack)new ItemStack((ItemLike)AtmosphericBlocks.PASSION_VINE.get(), 8));
        }
    }
}

