/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnderDragonFruitItem
extends Item {
    public EnderDragonFruitItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            stack.shrink(1);
            SoundEvent sound = SoundEvents.CHORUS_FRUIT_TELEPORT;
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.playSound(sound, 1.0f, 1.0f);
            entity.playSound(SoundEvents.ENDER_DRAGON_GROWL, 1.0f, 0.8f + entity.getRandom().nextFloat() * 0.3f);
            for (int i = 0; i < 8; ++i) {
                Vec3 vec3 = new Vec3((double)entity.getRandom().nextFloat() - 0.5, Math.random() * 0.1 + 0.1, 0.0);
                vec3 = vec3.xRot(-entity.getXRot() * ((float)Math.PI / 180));
                vec3 = vec3.yRot(-entity.getYRot() * ((float)Math.PI / 180));
                double d0 = (double)(-entity.getRandom().nextFloat()) * 0.1 - 0.3;
                Vec3 vec31 = new Vec3(((double)entity.getRandom().nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec31 = vec31.xRot(-entity.getXRot() * ((float)Math.PI / 180));
                vec31 = vec31.yRot(-entity.getYRot() * ((float)Math.PI / 180));
                vec31 = vec31.add(entity.getX(), entity.getEyeY(), entity.getZ());
                DustParticleOptions particleOptions = new DustParticleOptions(Vec3.fromRGB24((int)14437887).toVector3f(), 1.0f);
                Level level2 = entity.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.sendParticles((ParticleOptions)particleOptions, vec31.x, vec31.y, vec31.z, 1, vec3.x, vec3.y + 0.05, vec3.z, 0.0);
                    continue;
                }
                entity.level().addParticle((ParticleOptions)particleOptions, vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
            }
            return stack;
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        for (Holder holder : new Holder[]{MobEffects.ABSORPTION, MobEffects.REGENERATION, MobEffects.DAMAGE_RESISTANCE}) {
            MobEffect effect = (MobEffect)holder.value();
            MutableComponent component = Component.translatable((String)effect.getDescriptionId());
            MobEffectInstance instance = new MobEffectInstance(holder, 12000, 9);
            component = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
            component = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{component, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)context.level().tickRateManager().tickrate())});
            tooltip.add((Component)component.withStyle(effect.getCategory().getTooltipFormatting()));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 6000;
    }
}

