/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class MonkeyBrushItem
extends BlockItem {
    protected final Block wallBlock;

    public MonkeyBrushItem(Block floorBlock, Block wallBlockIn, Item.Properties propertiesIn) {
        super(floorBlock, propertiesIn);
        this.wallBlock = wallBlockIn;
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState wallState = this.wallBlock.getStateForPlacement(context);
        BlockState state = null;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState dirState;
            BlockState blockState = dirState = direction.getAxis().isVertical() ? this.getBlock().getStateForPlacement(context) : wallState;
            if (dirState == null || !dirState.canSurvive((LevelReader)level, pos)) continue;
            state = dirState;
            break;
        }
        return state != null && level.isUnobstructed(state, pos, CollisionContext.empty()) ? state : null;
    }

    public void registerBlocks(Map<Block, Item> blockToItemMap, Item item) {
        super.registerBlocks(blockToItemMap, item);
        blockToItemMap.put(this.wallBlock, item);
    }
}

