/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.item;

import com.teamabnormals.atmospheric.common.entity.projectile.PassionVineCoil;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PassionVineCoilItem
extends Item {
    public PassionVineCoilItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            PassionVineCoil coil = new PassionVineCoil(worldIn, (LivingEntity)playerIn);
            coil.setItem(itemstack);
            coil.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            worldIn.addFreshEntity((Entity)coil);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!playerIn.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)worldIn.isClientSide());
    }
}

