/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class AspenTreeFeature
extends BlueprintTreeFeature {
    public AspenTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        int leafHeight = trunkHeight - 7 - random.nextInt(3) - random.nextInt(3);
        int branchHeight = leafHeight - 2 - random.nextInt(3);
        int bonusBranchHeight = branchHeight - 2 - random.nextInt(3);
        for (int y = 0; y < trunkHeight; ++y) {
            BlockPos pos = origin.above(y);
            info.addLog(pos);
            if (y >= leafHeight) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    info.addFoliage(pos.relative(direction));
                    BlockPos offsetPos = pos.relative(direction).relative(direction.getClockWise());
                    if (y <= leafHeight || y >= trunkHeight - 1 || random.nextInt(4) == 0 && info.foliageMap().containsKey(offsetPos.below())) continue;
                    info.addFoliage(offsetPos);
                }
                if (y <= leafHeight + 1 || y >= trunkHeight - 2) continue;
                for (int i = -2; i <= 2; ++i) {
                    for (int k = -2; k <= 2; ++k) {
                        if (Math.abs(i) == 2 && Math.abs(k) == 2 || !random.nextBoolean()) continue;
                        info.addFoliage(pos.offset(i, 0, k));
                    }
                }
                continue;
            }
            if ((y != branchHeight || branchHeight <= 3 || random.nextInt(5) == 0) && (y != bonusBranchHeight || bonusBranchHeight <= 2 || random.nextInt(3) == 0)) continue;
            int branchSize = 1 + random.nextInt(2);
            if (random.nextBoolean()) {
                branchSize += 1 + random.nextInt(2);
            }
            ArrayList usedDirections = Lists.newArrayList();
            while (usedDirections.size() < branchSize) {
                Direction randomDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                if (usedDirections.contains(randomDirection)) continue;
                usedDirections.add(randomDirection);
            }
            for (Direction direction : usedDirections) {
                info.addFoliage(pos.relative(direction));
            }
        }
        info.addFoliage(origin.above(trunkHeight));
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.ASPEN_SAPLING.get()).defaultBlockState();
    }
}

