/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DragonRootsFeature
extends Feature<NoneFeatureConfiguration> {
    public DragonRootsFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        Direction direction = null;
        ArrayList positions = Lists.newArrayList();
        BlockState rootsState = ((Block)AtmosphericBlocks.DRAGON_ROOTS.get()).defaultBlockState();
        for (int j = 0; j < 256; ++j) {
            BlockPos offsetPos;
            if (direction == null) {
                offsetPos = origin.offset(random.nextInt(7) - random.nextInt(7), random.nextInt(3) - random.nextInt(3), random.nextInt(7) - random.nextInt(7));
                for (Direction dir : DragonRootsBlock.FACING.getPossibleValues()) {
                    if (!DragonRootsFeature.isOnSandstone(level, offsetPos, dir) || !level.isEmptyBlock(offsetPos)) continue;
                    direction = dir;
                    rootsState = (BlockState)rootsState.setValue((Property)DragonRootsBlock.FACING, (Comparable)direction.getOpposite());
                }
            } else {
                int wideOffset = random.nextInt(8) - random.nextInt(8);
                int shortOffset = random.nextInt(3) - random.nextInt(3);
                boolean xAxis = direction.getAxis() != Direction.Axis.X;
                offsetPos = origin.offset(xAxis ? wideOffset : shortOffset, random.nextInt(3) - random.nextInt(3), xAxis ? shortOffset : wideOffset);
            }
            if (direction == null || !DragonRootsFeature.isOnSandOrSandstone(level, offsetPos, direction) || !level.isEmptyBlock(offsetPos) || !rootsState.canSurvive((LevelReader)level, offsetPos) || positions.contains(offsetPos)) continue;
            positions.add(offsetPos);
        }
        if (positions.size() > 16) {
            for (BlockPos pos : positions) {
                boolean top = random.nextBoolean();
                boolean doubleRoots = random.nextBoolean();
                BlockState roots = (BlockState)((BlockState)rootsState.setValue(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)(top || doubleRoots ? DragonRootsStage.FRUIT : DragonRootsStage.NONE)))).setValue(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)(!top || doubleRoots ? DragonRootsStage.FRUIT : DragonRootsStage.NONE)));
                level.setBlock(pos, roots, 2);
            }
            return true;
        }
        return false;
    }

    public static boolean isOnSandstone(WorldGenLevel level, BlockPos pos, Direction direction) {
        BlockState state = level.getBlockState(pos.relative(direction));
        return state.is(Blocks.SANDSTONE) || state.is((Block)AtmosphericBlocks.ARID_SANDSTONE.get());
    }

    public static boolean isOnSandOrSandstone(WorldGenLevel level, BlockPos pos, Direction direction) {
        return level.getBlockState(pos.relative(direction)).is(BlockTags.SAND) || DragonRootsFeature.isOnSandstone(level, pos, direction);
    }
}

