/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class DuneRocksFeature
extends Feature<BlockStateConfiguration> {
    public DuneRocksFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockStateConfiguration config = (BlockStateConfiguration)context.config();
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        while (true) {
            Block block;
            if (pos.getY() <= 3 || !reader.isEmptyBlock(pos.below()) && ((block = reader.getBlockState(pos.below()).getBlock()) == AtmosphericBlocks.ARID_SAND.get() || block == AtmosphericBlocks.RED_ARID_SAND.get())) {
                if (pos.getY() <= 3) {
                    return false;
                }
                int i1 = rand.nextInt(2) + rand.nextInt(2);
                for (int l = 0; l < 3; ++l) {
                    int i = i1 + rand.nextInt(2);
                    int j = i1 + rand.nextInt(2);
                    int k = i1 + rand.nextInt(2);
                    float f = (float)(i + j + k) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-i, -j, -k), (BlockPos)pos.offset(i, j, k))) {
                        if (!(blockpos.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                        reader.setBlock(blockpos, config.state, 4);
                    }
                    pos = pos.offset(-(i1 + 1) + rand.nextInt(2 + i1 * 2), -rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
                }
                return true;
            }
            pos = pos.below();
        }
    }
}

