/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class FallenLogFeature
extends Feature<SimpleBlockConfiguration> {
    public FallenLogFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        SimpleBlockConfiguration config = (SimpleBlockConfiguration)context.config();
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        int length = 3 + random.nextInt(2) + random.nextInt(2);
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        HashSet logPositions = Sets.newHashSet();
        if (level.getBlockState(origin.below()).is((Block)AtmosphericBlocks.CRUSTOSE.get())) {
            for (int i = 0; i < length; ++i) {
                BlockPos offsetPos = origin.relative(direction, i);
                if (!level.isEmptyBlock(offsetPos) && !FallenLogFeature.isReplaceablePlant((LevelSimulatedReader)level, offsetPos) || level.isEmptyBlock(offsetPos.below())) {
                    return false;
                }
                logPositions.add(offsetPos.immutable());
            }
            if (logPositions.size() > 3) {
                logPositions.forEach(pos -> {
                    level.setBlock(pos, (BlockState)config.toPlace().getState(random, pos).setValue((Property)BlockStateProperties.AXIS, (Comparable)direction.getAxis()), 2);
                    if (level.getBlockState(pos.below()).is((Block)AtmosphericBlocks.CRUSTOSE.get())) {
                        level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
                    }
                });
                return true;
            }
        }
        return false;
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, state -> state.is(BlockTags.REPLACEABLE));
    }
}

