/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.levelgen.feature.LargeLaurelTreeFeature;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class GiantLaurelTreeFeature
extends LargeLaurelTreeFeature {
    public GiantLaurelTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    @Override
    public void addRoots(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info, Direction direction, BlockPos.MutableBlockPos pos) {
        int i;
        boolean xAxis;
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        boolean positive = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean bl = xAxis = direction.getAxis() == Direction.Axis.X;
        pos.set((Vec3i)origin.offset(xAxis ? (positive ? 1 : 0) : random.nextInt(2), 0, !xAxis ? (positive ? 1 : 0) : random.nextInt(2)));
        int length = 1 + random.nextInt(2);
        for (i = 0; i < length; ++i) {
            BlockPos rootPos = pos.relative(direction, i + 1);
            if (!GiantLaurelTreeFeature.isGrassOrDirt((LevelSimulatedReader)context.level(), (BlockPos)rootPos.below())) break;
            info.addLog(rootPos);
            GiantLaurelTreeFeature.setDirtAt((WorldGenLevel)context.level(), (RandomSource)random, (BlockPos)rootPos.below(), (TreeConfiguration)((TreeConfiguration)context.config()));
        }
        pos.set((Vec3i)origin.offset(xAxis ? (positive ? 1 : 0) : random.nextInt(2), 0, !xAxis ? (positive ? 1 : 0) : random.nextInt(2)));
        length = random.nextInt(2);
        for (i = 0; i < length; ++i) {
            BlockPos relativePos = pos.relative(direction, i + 1);
            info.addLog(relativePos);
            GiantLaurelTreeFeature.setDirtAt((WorldGenLevel)context.level(), (RandomSource)random, (BlockPos)relativePos.below(), (TreeConfiguration)((TreeConfiguration)context.config()));
        }
    }

    @Override
    public int getMaxLength() {
        return 5;
    }

    @Override
    public int getMaxHeight() {
        return 4;
    }

    @Override
    public int getSmallMaxSize() {
        return 3;
    }

    @Override
    public boolean limitBranches() {
        return false;
    }
}

