/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class GrimwoodTreeFeature
extends BlueprintTreeFeature {
    public GrimwoodTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < trunkHeight; ++j) {
                for (int k = 0; k < 2; ++k) {
                    BlockPos offset = origin.offset(i, j, k);
                    info.addLog(offset);
                    if (j != 0) continue;
                    GrimwoodTreeFeature.setDirtAt((WorldGenLevel)context.level(), (RandomSource)random, (BlockPos)offset.below(), (TreeConfiguration)config);
                }
            }
        }
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        boolean positive = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean xAxis = direction.getAxis() == Direction.Axis.X;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.set((Vec3i)origin.offset(xAxis ? (positive ? 1 : 0) : random.nextInt(2), trunkHeight, !xAxis ? (positive ? 1 : 0) : random.nextInt(2)));
        info.addLog((BlockPos)pos);
        this.createBranch(info, 2 + random.nextInt(2), 3 + random.nextInt(2), pos, direction);
        if (random.nextInt(3) != 0) {
            this.createBranch(info, 2 + random.nextInt(3), 3 + random.nextInt(2), pos, direction.getOpposite());
            this.createBranch(info, 1 + random.nextInt(2), 2 + random.nextInt(2), pos, direction);
        }
        int height = 5 + random.nextInt(5) + random.nextInt(3);
        this.createBranch(info, 1 + random.nextInt(3), height, pos, direction.getOpposite());
        info.addFoliage(pos.above());
        this.createLeafLayer(info, (BlockPos)pos, 1, true);
        boolean big = false;
        for (int i = 0; i < height - 2 - random.nextInt(2); ++i) {
            if (!big) {
                boolean bl = big = i > 3 && random.nextBoolean();
            }
            if (i % 2 != 0) continue;
            this.createLeafLayer(info, (BlockPos)pos.set((Vec3i)pos.below(2)), big ? 3 : 2, false);
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.GRIMWOOD_SAPLING.get()).defaultBlockState();
    }

    private void createBranch(BlueprintTreeFeature.TreeInfo info, int depth, int height, BlockPos.MutableBlockPos pos, Direction direction) {
        int j;
        for (j = 0; j < depth; ++j) {
            info.addAxisLog((BlockPos)pos.set((Vec3i)pos.relative(direction)), direction);
        }
        for (j = 0; j < height; ++j) {
            info.addLog((BlockPos)pos.set((Vec3i)pos.above()));
        }
    }

    private void createLeafLayer(BlueprintTreeFeature.TreeInfo info, BlockPos pos, int leafSize, boolean square) {
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                if (square) {
                    info.addFoliage(pos.offset(i, 0, k));
                    continue;
                }
                int xDis = Math.abs(i);
                int zDis = Math.abs(k);
                if (xDis == leafSize && zDis == leafSize || leafSize > 2 && (xDis == leafSize && zDis == leafSize - 1 || xDis == leafSize - 1 && zDis == leafSize)) continue;
                info.addFoliage(pos.offset(i, 0, k));
            }
        }
    }
}

