/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.levelgen.feature.LaurelTreeFeature;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class LargeLaurelTreeFeature
extends LaurelTreeFeature {
    public LargeLaurelTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    @Override
    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        boolean shortTrunk = false;
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 2; ++k) {
                int trunkHeight = LargeLaurelTreeFeature.getStumpHeight(config, random);
                if (trunkHeight == 2) {
                    if (!shortTrunk) {
                        shortTrunk = true;
                    } else {
                        while (trunkHeight == 2) {
                            trunkHeight = LargeLaurelTreeFeature.getStumpHeight(config, random);
                        }
                    }
                }
                for (int j = 0; j < trunkHeight; ++j) {
                    BlockPos offset = origin.offset(i, j, k);
                    info.addLog(offset);
                    if (j != 0) continue;
                    LargeLaurelTreeFeature.setDirtAt((WorldGenLevel)context.level(), (RandomSource)random, (BlockPos)offset.below(), (TreeConfiguration)config);
                }
            }
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean positive = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            boolean xAxis = direction.getAxis() == Direction.Axis.X;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            this.addRoots(context, info, direction, pos);
            pos.set((Vec3i)origin.offset(xAxis ? (positive ? 1 : 0) : random.nextInt(2), 0, !xAxis ? (positive ? 1 : 0) : random.nextInt(2)));
            int height = 0;
            while (info.logMap().containsKey(pos.above(height))) {
                ++height;
            }
            pos.set((Vec3i)pos.above(height - 1));
            if (height <= 2) continue;
            this.createBranch(info, (BlockPos)pos, direction, random, 3, this.getMaxLength(), this.getMaxHeight());
        }
    }

    public int getMaxLength() {
        return 4;
    }

    public int getMaxHeight() {
        return 3;
    }

    public void addRoots(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info, Direction direction, BlockPos.MutableBlockPos pos) {
    }

    private static int getStumpHeight(TreeConfiguration config, RandomSource random) {
        return config.trunkPlacer.getTreeHeight(random) - 1 + random.nextInt(2);
    }

    private void createBranch(BlueprintTreeFeature.TreeInfo info, BlockPos pos, Direction direction, RandomSource random, int minLength, int maxLength, int maxHeight) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.set((Vec3i)pos);
        int length = minLength;
        if (random.nextInt(3) == 0) {
            length = maxLength;
        }
        int height = 0;
        boolean bonus = false;
        for (int i = 0; i < length; ++i) {
            mutablePos.set((Vec3i)mutablePos.relative(direction));
            if (random.nextInt(2) == 0 && height < maxHeight) {
                mutablePos.set((Vec3i)mutablePos.above());
                ++height;
            }
            info.addLog((BlockPos)mutablePos);
            int smallMaxSize = this.getSmallMaxSize();
            if (i <= 0 || height >= maxHeight - 1 || minLength == 2 || bonus && this.limitBranches() || random.nextInt(this.getSmallMaxSize()) == 0) continue;
            this.createBranch(info, (BlockPos)mutablePos, random.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise(), random, 2, smallMaxSize, smallMaxSize);
            bonus = true;
        }
        this.createLeafChunk(info, (BlockPos)mutablePos, direction, random);
    }

    public int getSmallMaxSize() {
        return 2;
    }

    public boolean limitBranches() {
        return true;
    }
}

