/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class LaurelTreeFeature
extends BlueprintTreeFeature {
    public LaurelTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        for (int y = 0; y < trunkHeight; ++y) {
            info.addLog(origin.above(y));
        }
        Direction.Axis axis = Direction.Plane.HORIZONTAL.getRandomAxis(random);
        Direction.Plane.HORIZONTAL.stream().filter(direction -> direction.getAxis() == axis).forEach(direction -> this.createBranch(info, origin.above(trunkHeight), (Direction)direction, random));
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.LAUREL_SAPLING.get()).defaultBlockState();
    }

    private void createBranch(BlueprintTreeFeature.TreeInfo info, BlockPos pos, Direction direction, RandomSource random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.set((Vec3i)pos.relative(direction));
        int firstHeight = 1 + random.nextInt(2);
        mutablePos.set((Vec3i)mutablePos.below(random.nextInt(2)));
        for (int i = 0; i < firstHeight; ++i) {
            info.addLog(mutablePos.above(i));
        }
        int secondHeight = 1 + random.nextInt(2);
        mutablePos.set((Vec3i)mutablePos.relative(direction).above(firstHeight - random.nextInt(2)));
        for (int i = 0; i < secondHeight; ++i) {
            info.addLog(mutablePos.above(i));
        }
        mutablePos.set((Vec3i)mutablePos.above(secondHeight - 1));
        this.createLeafChunk(info, (BlockPos)mutablePos, direction, random);
    }

    public void createLeafChunk(BlueprintTreeFeature.TreeInfo info, BlockPos pos, Direction direction, RandomSource random) {
        this.createLeafLayer(info, pos.above(), false, random);
        this.createLeafLayer(info, pos, true, random);
        this.createLeafLayer(info, pos.below(), false, random);
        this.createVines(info, pos.below().immutable(), direction, random);
    }

    private void createLeafLayer(BlueprintTreeFeature.TreeInfo info, BlockPos pos, boolean square, RandomSource random) {
        int leafSize = 1;
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                if (square) {
                    info.addFoliage(pos.offset(i, 0, k));
                    continue;
                }
                if (Math.abs(i) != leafSize || Math.abs(k) != leafSize) {
                    info.addFoliage(pos.offset(i, 0, k));
                    continue;
                }
                if (random.nextInt(4) != 0) continue;
                info.addFoliage(pos.offset(i, 0, k));
            }
        }
    }

    private void createVines(BlueprintTreeFeature.TreeInfo info, BlockPos pos, Direction direction, RandomSource random) {
        HashSet vinePositions = Sets.newHashSet();
        int vineCount = 2 + random.nextInt(2) + random.nextInt(2);
        int placedVines = 0;
        while (placedVines < vineCount) {
            BlockPos.MutableBlockPos vinePos = new BlockPos.MutableBlockPos();
            vinePos.set((Vec3i)pos);
            if (random.nextInt(5) < 3) {
                vinePos.set((Vec3i)vinePos.relative(direction));
            }
            if (random.nextInt(5) < 4) {
                vinePos.set((Vec3i)(random.nextBoolean() ? vinePos.relative(direction.getClockWise()) : vinePos.relative(direction.getCounterClockWise())));
            }
            boolean canGen = pos.getX() != vinePos.getX() || pos.getZ() != vinePos.getZ();
            for (Direction vineDirection : Direction.values()) {
                if (!vinePositions.contains(vinePos.relative(vineDirection))) continue;
                canGen = false;
            }
            if (!canGen) continue;
            int length = 2 + random.nextInt(2);
            for (int i = 0; i < length; ++i) {
                info.addFoliage(vinePos.below(i));
            }
            ++placedVines;
            vinePositions.add(vinePos);
        }
    }
}

