/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericNoiseParameters;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.neoforged.neoforge.common.Tags;

public class OceanFloorRaiserFeature
extends Feature<NoneFeatureConfiguration> {
    public OceanFloorRaiserFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin = context.origin();
        int originX = origin.getX();
        int originZ = origin.getZ();
        int radius = 23;
        int minX = originX - radius;
        int minZ = originZ - radius;
        int maxX = originX + radius;
        int maxZ = originZ + radius;
        float radiusSquared = radius * radius;
        NormalNoise.NoiseParameters noise = (NormalNoise.NoiseParameters)context.level().registryAccess().registryOrThrow(Registries.NOISE).get(AtmosphericNoiseParameters.FLOOR_RAISE_RADIUS_OFFSET);
        if (noise == null) {
            return false;
        }
        NormalNoise radiusOffsetNoise = NormalNoise.create((RandomSource)new XoroshiroRandomSource(context.random().nextLong()), (NormalNoise.NoiseParameters)noise);
        WorldGenLevel level = context.level();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int heightRaise = 9;
        int boostedHeightRaise = heightRaise + 3;
        int raiseDecrease = boostedHeightRaise - 1;
        ArrayList<Raise> raises = new ArrayList<Raise>(Mth.square((int)(radius * 2)));
        ArrayList<DampeningPoint> dampeningPoints = new ArrayList<DampeningPoint>();
        for (int x = minX; x <= maxX; ++x) {
            int xDistanceSqr = Mth.square((int)(originX - x));
            for (int z = minZ; z <= maxZ; ++z) {
                int distanceSqr = xDistanceSqr + Mth.square((int)(originZ - z));
                if ((float)distanceSqr > radiusSquared && (double)distanceSqr > (double)radiusSquared + (double)(radiusSquared * 0.5f) * radiusOffsetNoise.getValue((double)x, 0.0, (double)z)) continue;
                int y = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
                if (y < 45) {
                    dampeningPoints.add(new DampeningPoint(x, z));
                    continue;
                }
                mutable.set(x, y, z);
                BlockState state = level.getBlockState((BlockPos)mutable);
                if (state.is(Blocks.MOSSY_COBBLESTONE)) {
                    state = Blocks.GRAVEL.defaultBlockState();
                }
                if (OceanFloorRaiserFeature.canReplace(state)) {
                    raises.add(new Raise(state, mutable.immutable(), (float)distanceSqr / radiusSquared));
                    continue;
                }
                dampeningPoints.add(new DampeningPoint(x, z));
            }
        }
        double dampeningPower = 1.0 / (double)raiseDecrease;
        for (DampeningPoint dampeningPoint : dampeningPoints) {
            int pointX = dampeningPoint.x;
            int pointZ = dampeningPoint.z;
            for (Raise raise : raises) {
                BlockPos pos = raise.pos;
                raise.dampeningFactor += 1.0 / (double)(Mth.square((int)(pos.getX() - pointX)) + Mth.square((int)(pos.getZ() - pointZ))) * dampeningPower;
            }
        }
        block4: for (Raise raise : raises) {
            BlockPos pos;
            int totalY;
            int increase = boostedHeightRaise - (int)(raise.dampeningFactor * (double)raiseDecrease);
            if (increase > heightRaise) {
                increase = heightRaise;
            }
            if ((totalY = (pos = raise.pos).getY() + increase) > 60) {
                increase -= totalY - 60;
            }
            mutable.set((Vec3i)pos);
            BlockState raiseState = raise.state;
            for (int i = 0; i < increase; ++i) {
                mutable.setY(mutable.getY() + 1);
                BlockState state = level.getBlockState((BlockPos)mutable);
                if (!OceanFloorRaiserFeature.canReplace(state) && !state.is(Blocks.MOSSY_COBBLESTONE) && !state.getFluidState().is(FluidTags.WATER)) continue block4;
                level.setBlock((BlockPos)mutable, raiseState, 2);
            }
        }
        return raises.size() > 0;
    }

    private static boolean canReplace(BlockState state) {
        return state.is(Tags.Blocks.GRAVELS) || state.is(BlockTags.DIRT) || state.is(BlockTags.SAND) || state.is(Blocks.CLAY) || state.is(BlockTags.BASE_STONE_OVERWORLD);
    }

    private record DampeningPoint(int x, int z) {
    }

    private static final class Raise {
        private final BlockState state;
        private final BlockPos pos;
        private double dampeningFactor;

        private Raise(BlockState state, BlockPos pos, double dampeningFactor) {
            this.state = state;
            this.pos = pos;
            this.dampeningFactor = dampeningFactor;
        }
    }
}

