/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.block.PassionVineBlock;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PassionVineFeature
extends Feature<NoneFeatureConfiguration> {
    public PassionVineFeature(Codec<NoneFeatureConfiguration> p_i49876_1_) {
        super(p_i49876_1_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        ArrayList positions = Lists.newArrayList();
        int i = 0;
        for (int j = 0; j < 400; ++j) {
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            BlockState state = (BlockState)((Block)AtmosphericBlocks.PASSION_VINE.get()).defaultBlockState().setValue((Property)PassionVineBlock.FACING, (Comparable)direction);
            BlockPos pos = origin.offset(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            int lengthA = 3 + random.nextInt(2) + random.nextInt(2) + random.nextInt(2) - random.nextInt(3);
            if (!level.isEmptyBlock(pos) || pos.getY() <= 50 || pos.getY() >= level.getMaxBuildHeight() || !state.canSurvive((LevelReader)level, pos)) continue;
            positions.add(pos);
            level.setBlock(pos, PassionVineFeature.getVineState(level, state, pos, random), 2);
            for (int length = 0; length < lengthA && level.isEmptyBlock(pos = pos.below()) && pos.getY() < level.getMaxBuildHeight() && state.canSurvive((LevelReader)level, pos); ++length) {
                positions.add(pos);
                level.setBlock(pos, PassionVineFeature.getVineState(level, state, pos, random), 2);
            }
            ++i;
        }
        positions.forEach(vinePos -> {
            BlockState state = level.getBlockState(vinePos);
            if (level.getBlockState(vinePos).is((Block)AtmosphericBlocks.PASSION_VINE.get())) {
                level.setBlock(vinePos, ((PassionVineBlock)state.getBlock()).determineState(state, (LevelReader)level, (BlockPos)vinePos), 2);
            }
        });
        return i > 0;
    }

    private static BlockState getVineState(WorldGenLevel world, BlockState state, BlockPos pos, RandomSource rand) {
        if (world.getBlockState(pos.relative(((Direction)state.getValue((Property)PassionVineBlock.FACING)).getOpposite())).is(AtmosphericBlockTags.PASSION_VINE_GROWABLE_ON)) {
            return (BlockState)state.setValue((Property)PassionVineBlock.AGE, (Comparable)Integer.valueOf(4));
        }
        return (BlockState)state.setValue((Property)PassionVineBlock.AGE, (Comparable)Integer.valueOf(1));
    }
}

