/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class RainforestTreeFeature
extends BlueprintTreeFeature {
    public RainforestTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        boolean tall;
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        boolean morado = config.trunkProvider.getState(random, origin).is((Block)AtmosphericBlocks.MORADO_LOG.get());
        int branches = 2 + random.nextInt(3) - (!morado ? 0 : 1);
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        boolean bl = tall = !morado && random.nextInt(100) == 0;
        if (tall) {
            trunkHeight += 6 + random.nextInt(4) + random.nextInt(3);
        }
        boolean canopy = false;
        for (int y = 0; y < trunkHeight; ++y) {
            BlockPos pos = origin.above(y);
            info.addLog(pos);
            if (random.nextInt(6) != 0 || y <= (!tall ? 3 : 8) || canopy) continue;
            this.createLeafLayer(info, pos, 1 + random.nextInt(2));
            canopy = true;
        }
        ArrayList directions = Lists.newArrayList();
        while (directions.size() < branches) {
            Direction randomDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            if (directions.contains(randomDirection)) continue;
            directions.add(randomDirection);
        }
        for (Direction direction : directions) {
            int turns = 1 + random.nextInt(3);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.set((Vec3i)origin.above(trunkHeight - 1));
            for (int k4 = 0; k4 < turns; ++k4) {
                int branchLength;
                int n = tall ? 2 + random.nextInt(2) : (branchLength = !morado ? 1 + random.nextInt(2) + random.nextInt(2) : 1 + random.nextInt(2));
                int branchHeight = tall ? 2 + random.nextInt(2) + random.nextInt(2) : (!morado ? 1 + random.nextInt(3) + random.nextInt(2) : 1 + random.nextInt(2));
                this.createHorizontalLog(info, branchLength, pos, direction);
                this.createVerticalLog(info, branchHeight, pos, random);
            }
            int leafSize = 2 + random.nextInt(2);
            this.createLeafLayer(info, (BlockPos)pos, leafSize);
            this.createLeafLayer(info, pos.above(), Math.max(leafSize - 1, 1));
        }
    }

    public void createLeafLayer(BlueprintTreeFeature.TreeInfo info, BlockPos pos, int leafSize) {
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                if (Math.abs(i) == leafSize && Math.abs(k) == leafSize) continue;
                info.addFoliage(pos.offset(i, 0, k));
            }
        }
    }

    private void createHorizontalLog(BlueprintTreeFeature.TreeInfo info, int branchLength, BlockPos.MutableBlockPos pos, Direction direction) {
        for (int i = 0; i < branchLength; ++i) {
            info.addAxisLog((BlockPos)pos.setWithOffset((Vec3i)pos, direction), direction);
        }
    }

    private void createVerticalLog(BlueprintTreeFeature.TreeInfo info, int branchHeight, BlockPos.MutableBlockPos pos, RandomSource random) {
        boolean canopy = false;
        for (int i = 0; i < branchHeight; ++i) {
            pos.set((Vec3i)pos.above());
            info.addLog((BlockPos)pos);
            if (random.nextInt(6) != 0 || canopy) continue;
            this.createLeafLayer(info, (BlockPos)pos, 1 + random.nextInt(2));
            canopy = true;
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.ROSEWOOD_SAPLING.get()).defaultBlockState();
    }

    public boolean canSurvive(WorldGenLevel level, BlockPos pos) {
        return super.canSurvive(level, pos) || level.getBlockState(pos.below()).is(Blocks.GRAVEL);
    }
}

