/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class SmallBushFeature
extends BlueprintTreeFeature {
    public SmallBushFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        for (int y = 0; y < trunkHeight; ++y) {
            info.addLog(origin.above(y));
        }
        this.createLeafLayer(info, origin, true, random);
        this.createLeafLayer(info, origin.above(trunkHeight), false, random);
    }

    private void createLeafLayer(BlueprintTreeFeature.TreeInfo info, BlockPos pos, boolean square, RandomSource random) {
        int leafSize = 1;
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                boolean corner;
                boolean bl = corner = Math.abs(i) == leafSize && Math.abs(k) == leafSize;
                if (square) {
                    if (corner && random.nextInt(3) == 0) continue;
                    info.addFoliage(pos.offset(i, 0, k));
                    continue;
                }
                if (corner || random.nextInt(3) == 0 && i != k) continue;
                info.addFoliage(pos.offset(i, 0, k));
            }
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.YUCCA_SAPLING.get()).defaultBlockState();
    }
}

