/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public class SnowyBambooFeature
extends Feature<ProbabilityFeatureConfiguration> {
    public SnowyBambooFeature(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        BlockState bambooTrunk = (BlockState)((BlockState)((BlockState)((Block)AtmosphericBlocks.SNOWY_BAMBOO.get()).defaultBlockState().setValue((Property)BambooStalkBlock.AGE, (Comparable)Integer.valueOf(1))).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.NONE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(0));
        BlockState bambooFinalLarge = (BlockState)((BlockState)bambooTrunk.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.LARGE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(1));
        BlockState bambooTopLarge = (BlockState)bambooTrunk.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.LARGE);
        BlockState bambooTopSmall = (BlockState)bambooTrunk.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL);
        int i = 0;
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        ProbabilityFeatureConfiguration config = (ProbabilityFeatureConfiguration)context.config();
        BlockPos.MutableBlockPos bambooPos = origin.mutable();
        BlockPos.MutableBlockPos snowPos = origin.mutable();
        if (level.isEmptyBlock((BlockPos)bambooPos)) {
            if (Blocks.BAMBOO.defaultBlockState().canSurvive((LevelReader)level, (BlockPos)bambooPos) || level.getBlockState(bambooPos.below()).is(Blocks.SNOW_BLOCK)) {
                level.setBlock(bambooPos.below(), Blocks.SNOW_BLOCK.defaultBlockState(), 2);
                int j = random.nextInt(12) + 5;
                if (random.nextFloat() < config.probability) {
                    int k = random.nextInt(4) + 1;
                    for (int l = origin.getX() - k; l <= origin.getX() + k; ++l) {
                        for (int i1 = origin.getZ() - k; i1 <= origin.getZ() + k; ++i1) {
                            int k1;
                            int j1 = l - origin.getX();
                            if (j1 * j1 + (k1 = i1 - origin.getZ()) * k1 > k * k) continue;
                            snowPos.set(l, level.getHeight(Heightmap.Types.WORLD_SURFACE, l, i1) - 1, i1);
                            if (!SnowyBambooFeature.isDirt((BlockState)level.getBlockState((BlockPos)snowPos))) continue;
                            level.setBlock((BlockPos)snowPos, Blocks.SNOW_BLOCK.defaultBlockState(), 2);
                        }
                    }
                }
                for (int l1 = 0; l1 < j && level.isEmptyBlock((BlockPos)bambooPos); ++l1) {
                    level.setBlock((BlockPos)bambooPos, bambooTrunk, 2);
                    bambooPos.move(Direction.UP, 1);
                }
                if (bambooPos.getY() - origin.getY() >= 3) {
                    level.setBlock((BlockPos)bambooPos, bambooFinalLarge, 2);
                    level.setBlock((BlockPos)bambooPos.move(Direction.DOWN, 1), bambooTopLarge, 2);
                    level.setBlock((BlockPos)bambooPos.move(Direction.DOWN, 1), bambooTopSmall, 2);
                }
            }
            ++i;
        }
        return i > 0;
    }
}

