/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.other.AtmosphericLootTables;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.LootTable;

public class SuspiciousAridSandFeature
extends Feature<NoneFeatureConfiguration> {
    public SuspiciousAridSandFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin().below();
        int i = SuspiciousAridSandFeature.placeSandLayer(level, pos, rand, 1, 0, 0, (IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)ConstantInt.ZERO) + SuspiciousAridSandFeature.placeSandLayer(level, pos, rand, 2, -2, -1, (IntProvider)UniformInt.of((int)2, (int)3), (IntProvider)UniformInt.of((int)0, (int)1)) + SuspiciousAridSandFeature.placeSandLayer(level, pos, rand, 2, -3, -2, (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)UniformInt.of((int)1, (int)3));
        if (i > 0) {
            for (BlockPos newPos : BlockPos.betweenClosedStream((BlockPos)pos.offset(-2, -4, -2), (BlockPos)pos.offset(2, -1, 2)).map(BlockPos::immutable).toList()) {
                Optional<Block> block = SuspiciousAridSandFeature.convertToSandstone(level.getBlockState(newPos));
                if (!rand.nextBoolean() || !block.isPresent()) continue;
                level.setBlock(newPos, block.get().defaultBlockState(), 2);
            }
            return true;
        }
        return false;
    }

    public static int placeSandLayer(WorldGenLevel level, BlockPos pos, RandomSource rand, int radius, int yMin, int yMax, IntProvider tries, IntProvider rareCount) {
        int i = 0;
        ArrayList layer1 = BlockPos.betweenClosedStream((BlockPos)pos.offset(-radius, yMin, -radius), (BlockPos)pos.offset(radius, yMax, radius)).filter(blockPos -> SuspiciousAridSandFeature.convertToSuspicious(level.getBlockState(blockPos)).isPresent()).map(BlockPos::immutable).collect(Collectors.toCollection(Lists::newArrayList));
        Collections.shuffle(layer1);
        if (!layer1.isEmpty()) {
            int attempts = tries.sample(rand);
            int rare = rareCount.sample(rand);
            for (int j = 0; j < attempts; ++j) {
                ResourceKey<LootTable> lootTable;
                BlockPos newPos = (BlockPos)layer1.get(j);
                if (rare > 0) {
                    lootTable = AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_RARE;
                    --rare;
                } else {
                    lootTable = AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_COMMON;
                }
                level.setBlock(newPos, SuspiciousAridSandFeature.convertToSuspicious(level.getBlockState(newPos)).get().defaultBlockState(), 2);
                level.getBlockEntity(newPos, BlockEntityType.BRUSHABLE_BLOCK).ifPresent(entity -> entity.setLootTable(lootTable, newPos.asLong()));
                ++i;
            }
        }
        return i;
    }

    public static Optional<Block> convertToSuspicious(BlockState state) {
        if (state.is((Block)AtmosphericBlocks.ARID_SAND.get()) || state.is((Block)AtmosphericBlocks.ARID_SANDSTONE.get())) {
            return Optional.of((Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get());
        }
        if (state.is((Block)AtmosphericBlocks.RED_ARID_SAND.get()) || state.is((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get())) {
            return Optional.of((Block)AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND.get());
        }
        return Optional.empty();
    }

    public static Optional<Block> convertToSandstone(BlockState state) {
        if (state.is((Block)AtmosphericBlocks.ARID_SAND.get())) {
            return Optional.of((Block)AtmosphericBlocks.ARID_SANDSTONE.get());
        }
        if (state.is((Block)AtmosphericBlocks.RED_ARID_SAND.get())) {
            return Optional.of((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get());
        }
        return Optional.empty();
    }
}

