/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public abstract class TerrainPatchFeature
extends Feature<ProbabilityFeatureConfiguration> {
    public TerrainPatchFeature(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        return this.doPlace(context, this.getTerrainState());
    }

    abstract BlockState getTerrainState();

    public boolean doPlace(FeaturePlaceContext<ProbabilityFeatureConfiguration> context, BlockState state) {
        ProbabilityFeatureConfiguration config = (ProbabilityFeatureConfiguration)context.config();
        WorldGenLevel worldIn = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutable = pos.mutable();
        if (rand.nextFloat() < config.probability) {
            int k = rand.nextInt(4) + 1;
            for (int l = pos.getX() - k; l <= pos.getX() + k; ++l) {
                for (int i1 = pos.getZ() - k; i1 <= pos.getZ() + k; ++i1) {
                    int k1;
                    int j1 = l - pos.getX();
                    if (j1 * j1 + (k1 = i1 - pos.getZ()) * k1 > k * k) continue;
                    blockpos$mutable.set(l, worldIn.getHeight(Heightmap.Types.WORLD_SURFACE, l, i1) - 1, i1);
                    if (!this.canReplace(worldIn.getBlockState((BlockPos)blockpos$mutable))) continue;
                    worldIn.setBlock((BlockPos)blockpos$mutable, state, 2);
                }
            }
            ++i;
        }
        return i > 0;
    }

    public boolean canReplace(BlockState state) {
        return TerrainPatchFeature.isDirt((BlockState)state);
    }
}

