/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class YuccaTreeFeature
extends BlueprintTreeFeature {
    public YuccaTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        for (int y = 0; y < trunkHeight; ++y) {
            info.addLog(origin.above(y));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.createYuccaBranch(info, origin.above(trunkHeight - 1), direction, random);
            this.createLeafLayer(info, pos.above(), random, false);
            this.createLeafLayer(info, pos, random, true);
            this.createLeafLayer(info, pos.below(), random, false);
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.YUCCA_SAPLING.get()).defaultBlockState();
    }

    public BlockPos createYuccaBranch(BlueprintTreeFeature.TreeInfo info, BlockPos pos, Direction direction, RandomSource rand) {
        int length = 4 + rand.nextInt(2);
        for (int i = 0; i < length; ++i) {
            info.addLog(pos.relative(direction));
            if (i == length - 1) continue;
            pos = pos.above().relative(direction, rand.nextInt(2));
        }
        return pos.relative(direction);
    }

    public void createLeafLayer(BlueprintTreeFeature.TreeInfo info, BlockPos newPos, RandomSource random, boolean square) {
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                if (square) {
                    info.addFoliage(newPos.offset(i, 0, k));
                    continue;
                }
                if (Math.abs(i) != 1 || Math.abs(k) != 1) {
                    info.addFoliage(newPos.offset(i, 0, k));
                    continue;
                }
                if (random.nextInt(4) != 0) continue;
                info.addFoliage(newPos.offset(i, 0, k));
            }
        }
    }
}

