/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CobwebDecorator
extends TreeDecorator {
    public static final MapCodec<CobwebDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CobwebDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public CobwebDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.COBWEB.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        if (!(random.nextFloat() >= this.probability)) {
            ObjectArrayList logs = context.logs();
            int i = ((BlockPos)logs.get(0)).getY();
            logs.stream().filter(pos -> pos.getY() - i > 5).forEach(pos -> {
                for (Direction direction : Direction.values()) {
                    Direction oppositeDirection;
                    BlockPos cobwebPos;
                    if (!(random.nextFloat() <= 0.05f) || !context.isAir(cobwebPos = pos.offset((oppositeDirection = direction.getOpposite()).getStepX(), oppositeDirection.getStepY(), oppositeDirection.getStepZ()))) continue;
                    context.setBlock(cobwebPos, ((Block)AtmosphericBlocks.GRIMWEB.get()).defaultBlockState());
                }
            });
        }
    }
}

