/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators.YuccaFlowerPatchDecorator;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class ExtendPetrifiedYuccaTreeDecorator
extends TreeDecorator {
    public static final MapCodec<ExtendPetrifiedYuccaTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(instance -> instance.blockProvider)).apply((Applicative)codec, ExtendPetrifiedYuccaTreeDecorator::new));
    private final BlockStateProvider blockProvider;

    public ExtendPetrifiedYuccaTreeDecorator(BlockStateProvider blockProvider) {
        this.blockProvider = blockProvider;
    }

    public void place(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.level();
        RandomSource random = context.random();
        BlockPos pos = YuccaFlowerPatchDecorator.getLowestBlockPos((ObjectArrayList<BlockPos>)context.logs());
        int height = 1 + random.nextInt(3);
        for (int i = 0; i < height; ++i) {
            BlockPos offsetPos = pos.below(i + 1);
            if (!level.isStateAtPosition(offsetPos, state -> state.is(BlockTags.SAND))) continue;
            context.setBlock(offsetPos, this.blockProvider.getState(random, offsetPos));
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.EXTEND_PETRIFIED_YUCCA_TREE.get();
    }
}

