/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HangingCurrantDecorator
extends TreeDecorator {
    public static final MapCodec<HangingCurrantDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(HangingCurrantDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public HangingCurrantDecorator(float probability) {
        this.probability = probability;
    }

    public void place(TreeDecorator.Context context) {
        for (BlockPos pos : context.leaves()) {
            if (!context.isAir(pos.below()) || !(context.random().nextFloat() < this.probability)) continue;
            context.setBlock(pos.below(), ((Block)AtmosphericBlocks.HANGING_CURRANT.get()).defaultBlockState());
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.HANGING_CURRANT.get();
    }
}

