/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.block.MonkeyBrushBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class MonkeyBrushDecorator
extends TreeDecorator {
    public static final MapCodec<MonkeyBrushDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(MonkeyBrushDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public MonkeyBrushDecorator(float probability) {
        this.probability = probability;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        if (random.nextFloat() < this.probability) {
            ArrayList<Block> brushes = new ArrayList<Block>();
            if (random.nextInt(2) == 0) {
                brushes.add((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get());
            }
            if (random.nextInt(3) == 0) {
                brushes.add((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get());
            }
            if (random.nextInt(4) == 0) {
                brushes.add((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get());
            }
            if (!brushes.isEmpty()) {
                for (BlockPos pos : context.logs()) {
                    for (Direction direction : Direction.values()) {
                        BlockPos offsetPos = pos.relative(direction);
                        if (random.nextInt(3) != 0 || !context.isAir(offsetPos)) continue;
                        context.setBlock(offsetPos, MonkeyBrushBlock.monkeyBrushState(((Block)brushes.get(random.nextInt(brushes.size()))).defaultBlockState(), direction));
                    }
                }
            }
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.MONKEY_BRUSH_DECORATOR.get();
    }
}

