/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.common.block.OrangeBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class OrangesDecorator
extends TreeDecorator {
    public static final MapCodec<OrangesDecorator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(instance -> instance.blockProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("orange_probability").forGetter(instance -> Float.valueOf(instance.orangeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_probability").forGetter(instance -> Float.valueOf(instance.doubleProbability))).apply((Applicative)codec, OrangesDecorator::new));
    private final float probability;
    private final float orangeProbability;
    private final float doubleProbability;
    private final BlockStateProvider blockProvider;

    public OrangesDecorator(float probability, BlockStateProvider provider, float orangeProbability, float doubleProbability) {
        this.probability = probability;
        this.blockProvider = provider;
        this.orangeProbability = orangeProbability;
        this.doubleProbability = doubleProbability;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        if (random.nextFloat() < this.probability) {
            for (BlockPos pos : context.leaves()) {
                ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.values()));
                directions.remove(Direction.UP);
                Collections.shuffle(directions);
                for (Direction direction : directions) {
                    BlockPos offsetPos = pos.relative(direction);
                    if (!(random.nextFloat() < this.orangeProbability) || !context.isAir(offsetPos)) continue;
                    context.setBlock(offsetPos, (BlockState)((BlockState)this.blockProvider.getState(random, offsetPos).setValue((Property)OrangeBlock.FACING, (Comparable)direction)).setValue((Property)OrangeBlock.ORANGES, (Comparable)Integer.valueOf(random.nextFloat() < this.doubleProbability ? 2 : 1)));
                }
            }
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.ORANGES.get();
    }
}

