/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators.YuccaFlowerPatchDecorator;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class RoastedYuccaBundleDecorator
extends TreeDecorator {
    public static final MapCodec<RoastedYuccaBundleDecorator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(instance -> instance.blockProvider)).apply((Applicative)codec, RoastedYuccaBundleDecorator::new));
    private final float probability;
    private final BlockStateProvider blockProvider;

    public RoastedYuccaBundleDecorator(float probability, BlockStateProvider blockProvider) {
        this.probability = probability;
        this.blockProvider = blockProvider;
    }

    public void place(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.level();
        RandomSource random = context.random();
        BlockPos pos = YuccaFlowerPatchDecorator.getLowestBlockPos((ObjectArrayList<BlockPos>)context.logs());
        if (random.nextFloat() < this.probability) {
            for (int j = 0; j < 12; ++j) {
                BlockPos offsetPos = pos.offset(random.nextInt(4) - random.nextInt(4), random.nextInt(3) - random.nextInt(3), random.nextInt(4) - random.nextInt(4));
                if (!context.isAir(offsetPos) || !level.isStateAtPosition(offsetPos.below(), state -> state.is(BlockTags.SAND))) continue;
                context.setBlock(offsetPos, this.blockProvider.getState(random, offsetPos));
                return;
            }
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.ROASTED_YUCCA_BUNDLE.get();
    }
}

