/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class YuccaBundleDecorator
extends TreeDecorator {
    public static final MapCodec<YuccaBundleDecorator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)BlockStateProvider.CODEC.fieldOf("bundle_provider").forGetter(instance -> instance.bundleProvider), (App)BlockStateProvider.CODEC.fieldOf("branch_provider").forGetter(instance -> instance.branchProvider)).apply((Applicative)codec, YuccaBundleDecorator::new));
    private final float probability;
    private final BlockStateProvider bundleProvider;
    private final BlockStateProvider branchProvider;

    public YuccaBundleDecorator(float probability, BlockStateProvider bundleProvider, BlockStateProvider branchProvider) {
        this.probability = probability;
        this.bundleProvider = bundleProvider;
        this.branchProvider = branchProvider;
    }

    public void place(TreeDecorator.Context context) {
        ObjectArrayList logs = context.logs();
        Collections.shuffle(logs);
        RandomSource random = context.random();
        if (context.random().nextFloat() < this.probability) {
            for (BlockPos pos : logs) {
                if (!context.isAir(pos.below()) || !context.isAir(pos.below(2))) continue;
                context.setBlock(pos.below(), this.branchProvider.getState(random, pos.below()));
                context.setBlock(pos.below(2), this.bundleProvider.getState(random, pos.below(2)));
                return;
            }
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.YUCCA_BUNDLE.get();
    }
}

